package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait UpdateType {
  def unwrap: software.amazon.awssdk.services.eks.model.UpdateType
}
object UpdateType {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.UpdateType
  ): zio.aws.eks.model.UpdateType = value match {
    case software.amazon.awssdk.services.eks.model.UpdateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.UpdateType.VERSION_UPDATE =>
      val r = VersionUpdate
      r
    case software.amazon.awssdk.services.eks.model.UpdateType.ENDPOINT_ACCESS_UPDATE =>
      val r = EndpointAccessUpdate
      r
    case software.amazon.awssdk.services.eks.model.UpdateType.LOGGING_UPDATE =>
      val r = LoggingUpdate
      r
    case software.amazon.awssdk.services.eks.model.UpdateType.CONFIG_UPDATE =>
      val r = ConfigUpdate
      r
    case software.amazon.awssdk.services.eks.model.UpdateType.ASSOCIATE_IDENTITY_PROVIDER_CONFIG =>
      val r = AssociateIdentityProviderConfig
      r
    case software.amazon.awssdk.services.eks.model.UpdateType.DISASSOCIATE_IDENTITY_PROVIDER_CONFIG =>
      val r = DisassociateIdentityProviderConfig
      r
    case software.amazon.awssdk.services.eks.model.UpdateType.ASSOCIATE_ENCRYPTION_CONFIG =>
      val r = AssociateEncryptionConfig
      r
    case software.amazon.awssdk.services.eks.model.UpdateType.ADDON_UPDATE =>
      val r = AddonUpdate
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.UNKNOWN_TO_SDK_VERSION
  }
  case object VersionUpdate extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.VERSION_UPDATE
  }
  case object EndpointAccessUpdate extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.ENDPOINT_ACCESS_UPDATE
  }
  case object LoggingUpdate extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.LOGGING_UPDATE
  }
  case object ConfigUpdate extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.CONFIG_UPDATE
  }
  case object AssociateIdentityProviderConfig
      extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.ASSOCIATE_IDENTITY_PROVIDER_CONFIG
  }
  case object DisassociateIdentityProviderConfig
      extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.DISASSOCIATE_IDENTITY_PROVIDER_CONFIG
  }
  case object AssociateEncryptionConfig extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.ASSOCIATE_ENCRYPTION_CONFIG
  }
  case object AddonUpdate extends zio.aws.eks.model.UpdateType {
    override def unwrap: software.amazon.awssdk.services.eks.model.UpdateType =
      software.amazon.awssdk.services.eks.model.UpdateType.ADDON_UPDATE
  }
}
