package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey, Timestamp}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Cluster(
    name: Option[String] = None,
    arn: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    version: Option[String] = None,
    endpoint: Option[String] = None,
    roleArn: Option[String] = None,
    resourcesVpcConfig: Option[zio.aws.eks.model.VpcConfigResponse] = None,
    kubernetesNetworkConfig: Option[
      zio.aws.eks.model.KubernetesNetworkConfigResponse
    ] = None,
    logging: Option[zio.aws.eks.model.Logging] = None,
    identity: Option[zio.aws.eks.model.Identity] = None,
    status: Option[zio.aws.eks.model.ClusterStatus] = None,
    certificateAuthority: Option[zio.aws.eks.model.Certificate] = None,
    clientRequestToken: Option[String] = None,
    platformVersion: Option[String] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    encryptionConfig: Option[Iterable[zio.aws.eks.model.EncryptionConfig]] =
      None,
    connectorConfig: Option[zio.aws.eks.model.ConnectorConfigResponse] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Cluster
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(resourcesVpcConfig.map(value => value.buildAwsValue()))(
        _.resourcesVpcConfig
      )
      .optionallyWith(
        kubernetesNetworkConfig.map(value => value.buildAwsValue())
      )(_.kubernetesNetworkConfig)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(identity.map(value => value.buildAwsValue()))(_.identity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(certificateAuthority.map(value => value.buildAwsValue()))(
        _.certificateAuthority
      )
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        encryptionConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.encryptionConfig)
      .optionallyWith(connectorConfig.map(value => value.buildAwsValue()))(
        _.connectorConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Cluster.ReadOnly =
    zio.aws.eks.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Cluster = zio.aws.eks.model.Cluster(
      name.map(value => value),
      arn.map(value => value),
      createdAt.map(value => value),
      version.map(value => value),
      endpoint.map(value => value),
      roleArn.map(value => value),
      resourcesVpcConfig.map(value => value.asEditable),
      kubernetesNetworkConfig.map(value => value.asEditable),
      logging.map(value => value.asEditable),
      identity.map(value => value.asEditable),
      status.map(value => value),
      certificateAuthority.map(value => value.asEditable),
      clientRequestToken.map(value => value),
      platformVersion.map(value => value),
      tags.map(value => value),
      encryptionConfig.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      connectorConfig.map(value => value.asEditable)
    )
    def name: Option[String]
    def arn: Option[String]
    def createdAt: Option[Timestamp]
    def version: Option[String]
    def endpoint: Option[String]
    def roleArn: Option[String]
    def resourcesVpcConfig: Option[zio.aws.eks.model.VpcConfigResponse.ReadOnly]
    def kubernetesNetworkConfig
        : Option[zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly]
    def logging: Option[zio.aws.eks.model.Logging.ReadOnly]
    def identity: Option[zio.aws.eks.model.Identity.ReadOnly]
    def status: Option[zio.aws.eks.model.ClusterStatus]
    def certificateAuthority: Option[zio.aws.eks.model.Certificate.ReadOnly]
    def clientRequestToken: Option[String]
    def platformVersion: Option[String]
    def tags: Option[Map[TagKey, TagValue]]
    def encryptionConfig
        : Option[List[zio.aws.eks.model.EncryptionConfig.ReadOnly]]
    def connectorConfig
        : Option[zio.aws.eks.model.ConnectorConfigResponse.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getResourcesVpcConfig
        : ZIO[Any, AwsError, zio.aws.eks.model.VpcConfigResponse.ReadOnly] =
      AwsError.unwrapOptionField("resourcesVpcConfig", resourcesVpcConfig)
    def getKubernetesNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kubernetesNetworkConfig",
      kubernetesNetworkConfig
    )
    def getLogging: ZIO[Any, AwsError, zio.aws.eks.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getIdentity: ZIO[Any, AwsError, zio.aws.eks.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("identity", identity)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.ClusterStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCertificateAuthority
        : ZIO[Any, AwsError, zio.aws.eks.model.Certificate.ReadOnly] =
      AwsError.unwrapOptionField("certificateAuthority", certificateAuthority)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncryptionConfig: ZIO[Any, AwsError, List[
      zio.aws.eks.model.EncryptionConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
    def getConnectorConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.ConnectorConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("connectorConfig", connectorConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Cluster
  ) extends zio.aws.eks.model.Cluster.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val endpoint: Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val roleArn: Option[String] =
      scala.Option(impl.roleArn()).map(value => value: String)
    override val resourcesVpcConfig
        : Option[zio.aws.eks.model.VpcConfigResponse.ReadOnly] = scala
      .Option(impl.resourcesVpcConfig())
      .map(value => zio.aws.eks.model.VpcConfigResponse.wrap(value))
    override val kubernetesNetworkConfig
        : Option[zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly] =
      scala
        .Option(impl.kubernetesNetworkConfig())
        .map(value =>
          zio.aws.eks.model.KubernetesNetworkConfigResponse.wrap(value)
        )
    override val logging: Option[zio.aws.eks.model.Logging.ReadOnly] = scala
      .Option(impl.logging())
      .map(value => zio.aws.eks.model.Logging.wrap(value))
    override val identity: Option[zio.aws.eks.model.Identity.ReadOnly] = scala
      .Option(impl.identity())
      .map(value => zio.aws.eks.model.Identity.wrap(value))
    override val status: Option[zio.aws.eks.model.ClusterStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.eks.model.ClusterStatus.wrap(value))
    override val certificateAuthority
        : Option[zio.aws.eks.model.Certificate.ReadOnly] = scala
      .Option(impl.certificateAuthority())
      .map(value => zio.aws.eks.model.Certificate.wrap(value))
    override val clientRequestToken: Option[String] =
      scala.Option(impl.clientRequestToken()).map(value => value: String)
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val encryptionConfig
        : Option[List[zio.aws.eks.model.EncryptionConfig.ReadOnly]] = scala
      .Option(impl.encryptionConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eks.model.EncryptionConfig.wrap(item)
        }.toList
      )
    override val connectorConfig
        : Option[zio.aws.eks.model.ConnectorConfigResponse.ReadOnly] = scala
      .Option(impl.connectorConfig())
      .map(value => zio.aws.eks.model.ConnectorConfigResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Cluster
  ): zio.aws.eks.model.Cluster.ReadOnly = new Wrapper(impl)
}
