package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ConnectorConfigResponse(
    activationId: Option[String] = None,
    activationCode: Option[String] = None,
    activationExpiry: Option[Timestamp] = None,
    provider: Option[String] = None,
    roleArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ConnectorConfigResponse = {
    import ConnectorConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ConnectorConfigResponse
      .builder()
      .optionallyWith(activationId.map(value => value: java.lang.String))(
        _.activationId
      )
      .optionallyWith(activationCode.map(value => value: java.lang.String))(
        _.activationCode
      )
      .optionallyWith(
        activationExpiry.map(value => Timestamp.unwrap(value): Instant)
      )(_.activationExpiry)
      .optionallyWith(provider.map(value => value: java.lang.String))(
        _.provider
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ConnectorConfigResponse.ReadOnly =
    zio.aws.eks.model.ConnectorConfigResponse.wrap(buildAwsValue())
}
object ConnectorConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ConnectorConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ConnectorConfigResponse =
      zio.aws.eks.model.ConnectorConfigResponse(
        activationId.map(value => value),
        activationCode.map(value => value),
        activationExpiry.map(value => value),
        provider.map(value => value),
        roleArn.map(value => value)
      )
    def activationId: Option[String]
    def activationCode: Option[String]
    def activationExpiry: Option[Timestamp]
    def provider: Option[String]
    def roleArn: Option[String]
    def getActivationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("activationId", activationId)
    def getActivationCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("activationCode", activationCode)
    def getActivationExpiry: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("activationExpiry", activationExpiry)
    def getProvider: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provider", provider)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ConnectorConfigResponse
  ) extends zio.aws.eks.model.ConnectorConfigResponse.ReadOnly {
    override val activationId: Option[String] =
      scala.Option(impl.activationId()).map(value => value: String)
    override val activationCode: Option[String] =
      scala.Option(impl.activationCode()).map(value => value: String)
    override val activationExpiry: Option[Timestamp] = scala
      .Option(impl.activationExpiry())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val provider: Option[String] =
      scala.Option(impl.provider()).map(value => value: String)
    override val roleArn: Option[String] =
      scala.Option(impl.roleArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ConnectorConfigResponse
  ): zio.aws.eks.model.ConnectorConfigResponse.ReadOnly = new Wrapper(impl)
}
