package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.ClusterName
import scala.jdk.CollectionConverters._
final case class DeleteAddonRequest(
    clusterName: ClusterName,
    addonName: String,
    preserve: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeleteAddonRequest = {
    import DeleteAddonRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeleteAddonRequest
      .builder()
      .clusterName(ClusterName.unwrap(clusterName): java.lang.String)
      .addonName(addonName: java.lang.String)
      .optionallyWith(preserve.map(value => value: java.lang.Boolean))(
        _.preserve
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeleteAddonRequest.ReadOnly =
    zio.aws.eks.model.DeleteAddonRequest.wrap(buildAwsValue())
}
object DeleteAddonRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeleteAddonRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeleteAddonRequest = zio.aws.eks.model
      .DeleteAddonRequest(clusterName, addonName, preserve.map(value => value))
    def clusterName: ClusterName
    def addonName: String
    def preserve: Option[Boolean]
    def getClusterName: ZIO[Any, Nothing, ClusterName] =
      ZIO.succeed(clusterName)
    def getAddonName: ZIO[Any, Nothing, String] = ZIO.succeed(addonName)
    def getPreserve: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("preserve", preserve)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeleteAddonRequest
  ) extends zio.aws.eks.model.DeleteAddonRequest.ReadOnly {
    override val clusterName: ClusterName =
      zio.aws.eks.model.primitives.ClusterName(impl.clusterName())
    override val addonName: String = impl.addonName(): String
    override val preserve: Option[Boolean] =
      scala.Option(impl.preserve()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeleteAddonRequest
  ): zio.aws.eks.model.DeleteAddonRequest.ReadOnly = new Wrapper(impl)
}
