package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteClusterRequest(name: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeleteClusterRequest
      .builder()
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeleteClusterRequest.ReadOnly =
    zio.aws.eks.model.DeleteClusterRequest.wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeleteClusterRequest =
      zio.aws.eks.model.DeleteClusterRequest(name)
    def name: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeleteClusterRequest
  ) extends zio.aws.eks.model.DeleteClusterRequest.ReadOnly {
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeleteClusterRequest
  ): zio.aws.eks.model.DeleteClusterRequest.ReadOnly = new Wrapper(impl)
}
