package zio.aws.eks.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.DescribeAddonVersionsRequestMaxResults
import scala.jdk.CollectionConverters._
final case class DescribeAddonVersionsRequest(
    kubernetesVersion: Option[String] = None,
    maxResults: Option[DescribeAddonVersionsRequestMaxResults] = None,
    nextToken: Option[String] = None,
    addonName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest = {
    import DescribeAddonVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest
      .builder()
      .optionallyWith(kubernetesVersion.map(value => value: java.lang.String))(
        _.kubernetesVersion
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeAddonVersionsRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeAddonVersionsRequest.ReadOnly =
    zio.aws.eks.model.DescribeAddonVersionsRequest.wrap(buildAwsValue())
}
object DescribeAddonVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeAddonVersionsRequest =
      zio.aws.eks.model.DescribeAddonVersionsRequest(
        kubernetesVersion.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        addonName.map(value => value)
      )
    def kubernetesVersion: Option[String]
    def maxResults: Option[DescribeAddonVersionsRequestMaxResults]
    def nextToken: Option[String]
    def addonName: Option[String]
    def getKubernetesVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kubernetesVersion", kubernetesVersion)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeAddonVersionsRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest
  ) extends zio.aws.eks.model.DescribeAddonVersionsRequest.ReadOnly {
    override val kubernetesVersion: Option[String] =
      scala.Option(impl.kubernetesVersion()).map(value => value: String)
    override val maxResults: Option[DescribeAddonVersionsRequestMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.eks.model.primitives
            .DescribeAddonVersionsRequestMaxResults(value)
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val addonName: Option[String] =
      scala.Option(impl.addonName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest
  ): zio.aws.eks.model.DescribeAddonVersionsRequest.ReadOnly = new Wrapper(impl)
}
