package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeNodegroupRequest(
    clusterName: String,
    nodegroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest = {
    import DescribeNodegroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodegroupName(nodegroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DescribeNodegroupRequest.ReadOnly =
    zio.aws.eks.model.DescribeNodegroupRequest.wrap(buildAwsValue())
}
object DescribeNodegroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeNodegroupRequest =
      zio.aws.eks.model.DescribeNodegroupRequest(clusterName, nodegroupName)
    def clusterName: String
    def nodegroupName: String
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodegroupName: ZIO[Any, Nothing, String] = ZIO.succeed(nodegroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest
  ) extends zio.aws.eks.model.DescribeNodegroupRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodegroupName: String = impl.nodegroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest
  ): zio.aws.eks.model.DescribeNodegroupRequest.ReadOnly = new Wrapper(impl)
}
