package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EncryptionConfig(
    resources: Option[Iterable[String]] = None,
    provider: Option[zio.aws.eks.model.Provider] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.EncryptionConfig = {
    import EncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.EncryptionConfig
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(provider.map(value => value.buildAwsValue()))(_.provider)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.EncryptionConfig.ReadOnly =
    zio.aws.eks.model.EncryptionConfig.wrap(buildAwsValue())
}
object EncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.EncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.EncryptionConfig =
      zio.aws.eks.model.EncryptionConfig(
        resources.map(value => value),
        provider.map(value => value.asEditable)
      )
    def resources: Option[List[String]]
    def provider: Option[zio.aws.eks.model.Provider.ReadOnly]
    def getResources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resources", resources)
    def getProvider: ZIO[Any, AwsError, zio.aws.eks.model.Provider.ReadOnly] =
      AwsError.unwrapOptionField("provider", provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.EncryptionConfig
  ) extends zio.aws.eks.model.EncryptionConfig.ReadOnly {
    override val resources: Option[List[String]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val provider: Option[zio.aws.eks.model.Provider.ReadOnly] = scala
      .Option(impl.provider())
      .map(value => zio.aws.eks.model.Provider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.EncryptionConfig
  ): zio.aws.eks.model.EncryptionConfig.ReadOnly = new Wrapper(impl)
}
