package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Identity(oidc: Option[zio.aws.eks.model.OIDC] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Identity = {
    import Identity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Identity
      .builder()
      .optionallyWith(oidc.map(value => value.buildAwsValue()))(_.oidc)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Identity.ReadOnly =
    zio.aws.eks.model.Identity.wrap(buildAwsValue())
}
object Identity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Identity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Identity =
      zio.aws.eks.model.Identity(oidc.map(value => value.asEditable))
    def oidc: Option[zio.aws.eks.model.OIDC.ReadOnly]
    def getOidc: ZIO[Any, AwsError, zio.aws.eks.model.OIDC.ReadOnly] =
      AwsError.unwrapOptionField("oidc", oidc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Identity
  ) extends zio.aws.eks.model.Identity.ReadOnly {
    override val oidc: Option[zio.aws.eks.model.OIDC.ReadOnly] =
      scala.Option(impl.oidc()).map(value => zio.aws.eks.model.OIDC.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Identity
  ): zio.aws.eks.model.Identity.ReadOnly = new Wrapper(impl)
}
