package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IdentityProviderConfig(`type`: String, name: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.IdentityProviderConfig = {
    import IdentityProviderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.IdentityProviderConfig
      .builder()
      .`type`(`type`: java.lang.String)
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.IdentityProviderConfig.ReadOnly =
    zio.aws.eks.model.IdentityProviderConfig.wrap(buildAwsValue())
}
object IdentityProviderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.IdentityProviderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.IdentityProviderConfig =
      zio.aws.eks.model.IdentityProviderConfig(`type`, name)
    def `type`: String
    def name: String
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.IdentityProviderConfig
  ) extends zio.aws.eks.model.IdentityProviderConfig.ReadOnly {
    override val `type`: String = impl.`type`(): String
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.IdentityProviderConfig
  ): zio.aws.eks.model.IdentityProviderConfig.ReadOnly = new Wrapper(impl)
}
