package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait IpFamily {
  def unwrap: software.amazon.awssdk.services.eks.model.IpFamily
}
object IpFamily {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.IpFamily
  ): zio.aws.eks.model.IpFamily = value match {
    case software.amazon.awssdk.services.eks.model.IpFamily.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.IpFamily.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.eks.model.IpFamily.IPV6 =>
      val r = ipv6
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.IpFamily {
    override def unwrap: software.amazon.awssdk.services.eks.model.IpFamily =
      software.amazon.awssdk.services.eks.model.IpFamily.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.eks.model.IpFamily {
    override def unwrap: software.amazon.awssdk.services.eks.model.IpFamily =
      software.amazon.awssdk.services.eks.model.IpFamily.IPV4
  }
  case object ipv6 extends zio.aws.eks.model.IpFamily {
    override def unwrap: software.amazon.awssdk.services.eks.model.IpFamily =
      software.amazon.awssdk.services.eks.model.IpFamily.IPV6
  }
}
