package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KubernetesNetworkConfigResponse(
    serviceIpv4Cidr: Option[String] = None,
    serviceIpv6Cidr: Option[String] = None,
    ipFamily: Option[zio.aws.eks.model.IpFamily] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse = {
    import KubernetesNetworkConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse
      .builder()
      .optionallyWith(serviceIpv4Cidr.map(value => value: java.lang.String))(
        _.serviceIpv4Cidr
      )
      .optionallyWith(serviceIpv6Cidr.map(value => value: java.lang.String))(
        _.serviceIpv6Cidr
      )
      .optionallyWith(ipFamily.map(value => value.unwrap))(_.ipFamily)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly =
    zio.aws.eks.model.KubernetesNetworkConfigResponse.wrap(buildAwsValue())
}
object KubernetesNetworkConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.KubernetesNetworkConfigResponse =
      zio.aws.eks.model.KubernetesNetworkConfigResponse(
        serviceIpv4Cidr.map(value => value),
        serviceIpv6Cidr.map(value => value),
        ipFamily.map(value => value)
      )
    def serviceIpv4Cidr: Option[String]
    def serviceIpv6Cidr: Option[String]
    def ipFamily: Option[zio.aws.eks.model.IpFamily]
    def getServiceIpv4Cidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceIpv4Cidr", serviceIpv4Cidr)
    def getServiceIpv6Cidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceIpv6Cidr", serviceIpv6Cidr)
    def getIpFamily: ZIO[Any, AwsError, zio.aws.eks.model.IpFamily] =
      AwsError.unwrapOptionField("ipFamily", ipFamily)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse
  ) extends zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly {
    override val serviceIpv4Cidr: Option[String] =
      scala.Option(impl.serviceIpv4Cidr()).map(value => value: String)
    override val serviceIpv6Cidr: Option[String] =
      scala.Option(impl.serviceIpv6Cidr()).map(value => value: String)
    override val ipFamily: Option[zio.aws.eks.model.IpFamily] = scala
      .Option(impl.ipFamily())
      .map(value => zio.aws.eks.model.IpFamily.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse
  ): zio.aws.eks.model.KubernetesNetworkConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
