package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Logging(
    clusterLogging: Option[Iterable[zio.aws.eks.model.LogSetup]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Logging = {
    import Logging.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Logging
      .builder()
      .optionallyWith(
        clusterLogging.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterLogging)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Logging.ReadOnly =
    zio.aws.eks.model.Logging.wrap(buildAwsValue())
}
object Logging {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Logging] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Logging = zio.aws.eks.model.Logging(
      clusterLogging.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def clusterLogging: Option[List[zio.aws.eks.model.LogSetup.ReadOnly]]
    def getClusterLogging
        : ZIO[Any, AwsError, List[zio.aws.eks.model.LogSetup.ReadOnly]] =
      AwsError.unwrapOptionField("clusterLogging", clusterLogging)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Logging
  ) extends zio.aws.eks.model.Logging.ReadOnly {
    override val clusterLogging
        : Option[List[zio.aws.eks.model.LogSetup.ReadOnly]] = scala
      .Option(impl.clusterLogging())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eks.model.LogSetup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Logging
  ): zio.aws.eks.model.Logging.ReadOnly = new Wrapper(impl)
}
