package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodegroupHealth(
    issues: Option[Iterable[zio.aws.eks.model.Issue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.NodegroupHealth = {
    import NodegroupHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.NodegroupHealth
      .builder()
      .optionallyWith(
        issues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.issues)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.NodegroupHealth.ReadOnly =
    zio.aws.eks.model.NodegroupHealth.wrap(buildAwsValue())
}
object NodegroupHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.NodegroupHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.NodegroupHealth =
      zio.aws.eks.model.NodegroupHealth(
        issues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def issues: Option[List[zio.aws.eks.model.Issue.ReadOnly]]
    def getIssues: ZIO[Any, AwsError, List[zio.aws.eks.model.Issue.ReadOnly]] =
      AwsError.unwrapOptionField("issues", issues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.NodegroupHealth
  ) extends zio.aws.eks.model.NodegroupHealth.ReadOnly {
    override val issues: Option[List[zio.aws.eks.model.Issue.ReadOnly]] = scala
      .Option(impl.issues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eks.model.Issue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.NodegroupHealth
  ): zio.aws.eks.model.NodegroupHealth.ReadOnly = new Wrapper(impl)
}
