package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateClusterConfigRequest(
    name: String,
    resourcesVpcConfig: Option[zio.aws.eks.model.VpcConfigRequest] = None,
    logging: Option[zio.aws.eks.model.Logging] = None,
    clientRequestToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest = {
    import UpdateClusterConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(resourcesVpcConfig.map(value => value.buildAwsValue()))(
        _.resourcesVpcConfig
      )
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateClusterConfigRequest.ReadOnly =
    zio.aws.eks.model.UpdateClusterConfigRequest.wrap(buildAwsValue())
}
object UpdateClusterConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateClusterConfigRequest =
      zio.aws.eks.model.UpdateClusterConfigRequest(
        name,
        resourcesVpcConfig.map(value => value.asEditable),
        logging.map(value => value.asEditable),
        clientRequestToken.map(value => value)
      )
    def name: String
    def resourcesVpcConfig: Option[zio.aws.eks.model.VpcConfigRequest.ReadOnly]
    def logging: Option[zio.aws.eks.model.Logging.ReadOnly]
    def clientRequestToken: Option[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getResourcesVpcConfig
        : ZIO[Any, AwsError, zio.aws.eks.model.VpcConfigRequest.ReadOnly] =
      AwsError.unwrapOptionField("resourcesVpcConfig", resourcesVpcConfig)
    def getLogging: ZIO[Any, AwsError, zio.aws.eks.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest
  ) extends zio.aws.eks.model.UpdateClusterConfigRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val resourcesVpcConfig
        : Option[zio.aws.eks.model.VpcConfigRequest.ReadOnly] = scala
      .Option(impl.resourcesVpcConfig())
      .map(value => zio.aws.eks.model.VpcConfigRequest.wrap(value))
    override val logging: Option[zio.aws.eks.model.Logging.ReadOnly] = scala
      .Option(impl.logging())
      .map(value => zio.aws.eks.model.Logging.wrap(value))
    override val clientRequestToken: Option[String] =
      scala.Option(impl.clientRequestToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest
  ): zio.aws.eks.model.UpdateClusterConfigRequest.ReadOnly = new Wrapper(impl)
}
