package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AuthorizeCacheSecurityGroupIngressResponse(
    cacheSecurityGroup: Optional[zio.aws.elasticache.model.CacheSecurityGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse = {
    import AuthorizeCacheSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse
      .builder()
      .optionallyWith(cacheSecurityGroup.map(value => value.buildAwsValue()))(
        _.cacheSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.ReadOnly =
    zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse
      .wrap(buildAwsValue())
}
object AuthorizeCacheSecurityGroupIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse =
      zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse(
        cacheSecurityGroup.map(value => value.asEditable)
      )
    def cacheSecurityGroup
        : Optional[zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly]
    def getCacheSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("cacheSecurityGroup", cacheSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse
  ) extends zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.ReadOnly {
    override val cacheSecurityGroup
        : Optional[zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSecurityGroup())
        .map(value => zio.aws.elasticache.model.CacheSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse
  ): zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.ReadOnly =
    new Wrapper(impl)
}
