package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGlobalReplicationGroupResponse(
    globalReplicationGroup: Optional[
      zio.aws.elasticache.model.GlobalReplicationGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupResponse = {
    import CreateGlobalReplicationGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupResponse
      .builder()
      .optionallyWith(
        globalReplicationGroup.map(value => value.buildAwsValue())
      )(_.globalReplicationGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.ReadOnly =
    zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse
      .wrap(buildAwsValue())
}
object CreateGlobalReplicationGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse =
      zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse(
        globalReplicationGroup.map(value => value.asEditable)
      )
    def globalReplicationGroup
        : Optional[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly]
    def getGlobalReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalReplicationGroup",
      globalReplicationGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupResponse
  ) extends zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.ReadOnly {
    override val globalReplicationGroup
        : Optional[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroup())
        .map(value =>
          zio.aws.elasticache.model.GlobalReplicationGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupResponse
  ): zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.ReadOnly =
    new Wrapper(impl)
}
