package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DecreaseNodeGroupsInGlobalReplicationGroupRequest(
    globalReplicationGroupId: String,
    nodeGroupCount: Integer,
    globalNodeGroupsToRemove: Optional[Iterable[String]] = Optional.Absent,
    globalNodeGroupsToRetain: Optional[Iterable[String]] = Optional.Absent,
    applyImmediately: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest = {
    import DecreaseNodeGroupsInGlobalReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest
      .builder()
      .globalReplicationGroupId(globalReplicationGroupId: java.lang.String)
      .nodeGroupCount(nodeGroupCount: java.lang.Integer)
      .optionallyWith(
        globalNodeGroupsToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.globalNodeGroupsToRemove)
      .optionallyWith(
        globalNodeGroupsToRetain.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.globalNodeGroupsToRetain)
      .applyImmediately(applyImmediately: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest
      .wrap(buildAwsValue())
}
object DecreaseNodeGroupsInGlobalReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest =
      zio.aws.elasticache.model
        .DecreaseNodeGroupsInGlobalReplicationGroupRequest(
          globalReplicationGroupId,
          nodeGroupCount,
          globalNodeGroupsToRemove.map(value => value),
          globalNodeGroupsToRetain.map(value => value),
          applyImmediately
        )
    def globalReplicationGroupId: String
    def nodeGroupCount: Integer
    def globalNodeGroupsToRemove: Optional[List[String]]
    def globalNodeGroupsToRetain: Optional[List[String]]
    def applyImmediately: Boolean
    def getGlobalReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalReplicationGroupId)
    def getNodeGroupCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(nodeGroupCount)
    def getGlobalNodeGroupsToRemove: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("globalNodeGroupsToRemove", globalNodeGroupsToRemove)
    def getGlobalNodeGroupsToRetain: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("globalNodeGroupsToRetain", globalNodeGroupsToRetain)
    def getApplyImmediately: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(applyImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest
  ) extends zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest.ReadOnly {
    override val globalReplicationGroupId: String =
      impl.globalReplicationGroupId(): String
    override val nodeGroupCount: Integer = impl.nodeGroupCount(): Integer
    override val globalNodeGroupsToRemove: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNodeGroupsToRemove())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val globalNodeGroupsToRetain: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNodeGroupsToRetain())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val applyImmediately: Boolean = impl.applyImmediately(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest
  ): zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
