package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCacheSubnetGroupRequest(cacheSubnetGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest = {
    import DeleteCacheSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest
      .builder()
      .cacheSubnetGroupName(cacheSubnetGroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DeleteCacheSubnetGroupRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteCacheSubnetGroupRequest
      .wrap(buildAwsValue())
}
object DeleteCacheSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteCacheSubnetGroupRequest =
      zio.aws.elasticache.model
        .DeleteCacheSubnetGroupRequest(cacheSubnetGroupName)
    def cacheSubnetGroupName: String
    def getCacheSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheSubnetGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest
  ) extends zio.aws.elasticache.model.DeleteCacheSubnetGroupRequest.ReadOnly {
    override val cacheSubnetGroupName: String =
      impl.cacheSubnetGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest
  ): zio.aws.elasticache.model.DeleteCacheSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
