package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeCacheParameterGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    cacheParameterGroups: Optional[
      Iterable[zio.aws.elasticache.model.CacheParameterGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse = {
    import DescribeCacheParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        cacheParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheParameterGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeCacheParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse =
      zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse(
        marker.map(value => value),
        cacheParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def cacheParameterGroups
        : Optional[List[zio.aws.elasticache.model.CacheParameterGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCacheParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheParameterGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("cacheParameterGroups", cacheParameterGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse
  ) extends zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val cacheParameterGroups: Optional[
      List[zio.aws.elasticache.model.CacheParameterGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheParameterGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse
  ): zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
