package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class NodeSnapshot(
    cacheClusterId: Optional[String] = Optional.Absent,
    nodeGroupId: Optional[String] = Optional.Absent,
    cacheNodeId: Optional[String] = Optional.Absent,
    nodeGroupConfiguration: Optional[
      zio.aws.elasticache.model.NodeGroupConfiguration
    ] = Optional.Absent,
    cacheSize: Optional[String] = Optional.Absent,
    cacheNodeCreateTime: Optional[TStamp] = Optional.Absent,
    snapshotCreateTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeSnapshot = {
    import NodeSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeSnapshot
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(nodeGroupId.map(value => value: java.lang.String))(
        _.nodeGroupId
      )
      .optionallyWith(cacheNodeId.map(value => value: java.lang.String))(
        _.cacheNodeId
      )
      .optionallyWith(
        nodeGroupConfiguration.map(value => value.buildAwsValue())
      )(_.nodeGroupConfiguration)
      .optionallyWith(cacheSize.map(value => value: java.lang.String))(
        _.cacheSize
      )
      .optionallyWith(
        cacheNodeCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.cacheNodeCreateTime)
      .optionallyWith(
        snapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreateTime)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.NodeSnapshot.ReadOnly =
    zio.aws.elasticache.model.NodeSnapshot.wrap(buildAwsValue())
}
object NodeSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeSnapshot =
      zio.aws.elasticache.model.NodeSnapshot(
        cacheClusterId.map(value => value),
        nodeGroupId.map(value => value),
        cacheNodeId.map(value => value),
        nodeGroupConfiguration.map(value => value.asEditable),
        cacheSize.map(value => value),
        cacheNodeCreateTime.map(value => value),
        snapshotCreateTime.map(value => value)
      )
    def cacheClusterId: Optional[String]
    def nodeGroupId: Optional[String]
    def cacheNodeId: Optional[String]
    def nodeGroupConfiguration
        : Optional[zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly]
    def cacheSize: Optional[String]
    def cacheNodeCreateTime: Optional[TStamp]
    def snapshotCreateTime: Optional[TStamp]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getNodeGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeGroupId", nodeGroupId)
    def getCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeId", cacheNodeId)
    def getNodeGroupConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeGroupConfiguration",
      nodeGroupConfiguration
    )
    def getCacheSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSize", cacheSize)
    def getCacheNodeCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cacheNodeCreateTime", cacheNodeCreateTime)
    def getSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeSnapshot
  ) extends zio.aws.elasticache.model.NodeSnapshot.ReadOnly {
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val nodeGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeGroupId())
      .map(value => value: String)
    override val cacheNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeId())
      .map(value => value: String)
    override val nodeGroupConfiguration
        : Optional[zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeGroupConfiguration())
        .map(value =>
          zio.aws.elasticache.model.NodeGroupConfiguration.wrap(value)
        )
    override val cacheSize: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheSize())
      .map(value => value: String)
    override val cacheNodeCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeCreateTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val snapshotCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotCreateTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeSnapshot
  ): zio.aws.elasticache.model.NodeSnapshot.ReadOnly = new Wrapper(impl)
}
