package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait NodeUpdateStatus {
  def unwrap: software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus
}
object NodeUpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus
  ): zio.aws.elasticache.model.NodeUpdateStatus = value match {
    case software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.NOT_APPLIED =>
      val r = `not-applied`
      r
    case software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.WAITING_TO_START =>
      val r = `waiting-to-start`
      r
    case software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.IN_PROGRESS =>
      val r = `in-progress`
      r
    case software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.STOPPING =>
      val r = stopping
      r
    case software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.STOPPED =>
      val r = stopped
      r
    case software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.COMPLETE =>
      val r = complete
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.NodeUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object `not-applied` extends zio.aws.elasticache.model.NodeUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.NOT_APPLIED
  }
  case object `waiting-to-start`
      extends zio.aws.elasticache.model.NodeUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.WAITING_TO_START
  }
  case object `in-progress` extends zio.aws.elasticache.model.NodeUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.IN_PROGRESS
  }
  case object stopping extends zio.aws.elasticache.model.NodeUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.STOPPING
  }
  case object stopped extends zio.aws.elasticache.model.NodeUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.STOPPED
  }
  case object complete extends zio.aws.elasticache.model.NodeUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus.COMPLETE
  }
}
