package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResetCacheParameterGroupRequest(
    cacheParameterGroupName: String,
    resetAllParameters: Optional[Boolean] = Optional.Absent,
    parameterNameValues: Optional[
      Iterable[zio.aws.elasticache.model.ParameterNameValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest = {
    import ResetCacheParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest
      .builder()
      .cacheParameterGroupName(cacheParameterGroupName: java.lang.String)
      .optionallyWith(
        resetAllParameters.map(value => value: java.lang.Boolean)
      )(_.resetAllParameters)
      .optionallyWith(
        parameterNameValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterNameValues)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ResetCacheParameterGroupRequest.ReadOnly =
    zio.aws.elasticache.model.ResetCacheParameterGroupRequest
      .wrap(buildAwsValue())
}
object ResetCacheParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ResetCacheParameterGroupRequest =
      zio.aws.elasticache.model.ResetCacheParameterGroupRequest(
        cacheParameterGroupName,
        resetAllParameters.map(value => value),
        parameterNameValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheParameterGroupName: String
    def resetAllParameters: Optional[Boolean]
    def parameterNameValues
        : Optional[List[zio.aws.elasticache.model.ParameterNameValue.ReadOnly]]
    def getCacheParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheParameterGroupName)
    def getResetAllParameters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resetAllParameters", resetAllParameters)
    def getParameterNameValues: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ParameterNameValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterNameValues", parameterNameValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest
  ) extends zio.aws.elasticache.model.ResetCacheParameterGroupRequest.ReadOnly {
    override val cacheParameterGroupName: String =
      impl.cacheParameterGroupName(): String
    override val resetAllParameters: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.resetAllParameters())
      .map(value => value: Boolean)
    override val parameterNameValues: Optional[
      List[zio.aws.elasticache.model.ParameterNameValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterNameValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ParameterNameValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest
  ): zio.aws.elasticache.model.ResetCacheParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
