package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{BooleanOptional, TStamp}
import scala.jdk.CollectionConverters.*
final case class ServiceUpdate(
    serviceUpdateName: Optional[String] = Optional.Absent,
    serviceUpdateReleaseDate: Optional[TStamp] = Optional.Absent,
    serviceUpdateEndDate: Optional[TStamp] = Optional.Absent,
    serviceUpdateSeverity: Optional[
      zio.aws.elasticache.model.ServiceUpdateSeverity
    ] = Optional.Absent,
    serviceUpdateRecommendedApplyByDate: Optional[TStamp] = Optional.Absent,
    serviceUpdateStatus: Optional[
      zio.aws.elasticache.model.ServiceUpdateStatus
    ] = Optional.Absent,
    serviceUpdateDescription: Optional[String] = Optional.Absent,
    serviceUpdateType: Optional[zio.aws.elasticache.model.ServiceUpdateType] =
      Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoUpdateAfterRecommendedApplyByDate: Optional[BooleanOptional] =
      Optional.Absent,
    estimatedUpdateTime: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ServiceUpdate = {
    import ServiceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ServiceUpdate
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        serviceUpdateReleaseDate.map(value => TStamp.unwrap(value): Instant)
      )(_.serviceUpdateReleaseDate)
      .optionallyWith(
        serviceUpdateEndDate.map(value => TStamp.unwrap(value): Instant)
      )(_.serviceUpdateEndDate)
      .optionallyWith(serviceUpdateSeverity.map(value => value.unwrap))(
        _.serviceUpdateSeverity
      )
      .optionallyWith(
        serviceUpdateRecommendedApplyByDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.serviceUpdateRecommendedApplyByDate)
      .optionallyWith(serviceUpdateStatus.map(value => value.unwrap))(
        _.serviceUpdateStatus
      )
      .optionallyWith(
        serviceUpdateDescription.map(value => value: java.lang.String)
      )(_.serviceUpdateDescription)
      .optionallyWith(serviceUpdateType.map(value => value.unwrap))(
        _.serviceUpdateType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoUpdateAfterRecommendedApplyByDate.map(value =>
          value: java.lang.Boolean
        )
      )(_.autoUpdateAfterRecommendedApplyByDate)
      .optionallyWith(
        estimatedUpdateTime.map(value => value: java.lang.String)
      )(_.estimatedUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ServiceUpdate.ReadOnly =
    zio.aws.elasticache.model.ServiceUpdate.wrap(buildAwsValue())
}
object ServiceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ServiceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ServiceUpdate =
      zio.aws.elasticache.model.ServiceUpdate(
        serviceUpdateName.map(value => value),
        serviceUpdateReleaseDate.map(value => value),
        serviceUpdateEndDate.map(value => value),
        serviceUpdateSeverity.map(value => value),
        serviceUpdateRecommendedApplyByDate.map(value => value),
        serviceUpdateStatus.map(value => value),
        serviceUpdateDescription.map(value => value),
        serviceUpdateType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        autoUpdateAfterRecommendedApplyByDate.map(value => value),
        estimatedUpdateTime.map(value => value)
      )
    def serviceUpdateName: Optional[String]
    def serviceUpdateReleaseDate: Optional[TStamp]
    def serviceUpdateEndDate: Optional[TStamp]
    def serviceUpdateSeverity
        : Optional[zio.aws.elasticache.model.ServiceUpdateSeverity]
    def serviceUpdateRecommendedApplyByDate: Optional[TStamp]
    def serviceUpdateStatus
        : Optional[zio.aws.elasticache.model.ServiceUpdateStatus]
    def serviceUpdateDescription: Optional[String]
    def serviceUpdateType: Optional[zio.aws.elasticache.model.ServiceUpdateType]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def autoUpdateAfterRecommendedApplyByDate: Optional[BooleanOptional]
    def estimatedUpdateTime: Optional[String]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getServiceUpdateReleaseDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("serviceUpdateReleaseDate", serviceUpdateReleaseDate)
    def getServiceUpdateEndDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("serviceUpdateEndDate", serviceUpdateEndDate)
    def getServiceUpdateSeverity
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateSeverity] =
      AwsError.unwrapOptionField("serviceUpdateSeverity", serviceUpdateSeverity)
    def getServiceUpdateRecommendedApplyByDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "serviceUpdateRecommendedApplyByDate",
        serviceUpdateRecommendedApplyByDate
      )
    def getServiceUpdateStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateStatus] =
      AwsError.unwrapOptionField("serviceUpdateStatus", serviceUpdateStatus)
    def getServiceUpdateDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("serviceUpdateDescription", serviceUpdateDescription)
    def getServiceUpdateType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateType] =
      AwsError.unwrapOptionField("serviceUpdateType", serviceUpdateType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoUpdateAfterRecommendedApplyByDate
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "autoUpdateAfterRecommendedApplyByDate",
      autoUpdateAfterRecommendedApplyByDate
    )
    def getEstimatedUpdateTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("estimatedUpdateTime", estimatedUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ServiceUpdate
  ) extends zio.aws.elasticache.model.ServiceUpdate.ReadOnly {
    override val serviceUpdateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateName())
      .map(value => value: String)
    override val serviceUpdateReleaseDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateReleaseDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateEndDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateEndDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateSeverity
        : Optional[zio.aws.elasticache.model.ServiceUpdateSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateSeverity())
        .map(value =>
          zio.aws.elasticache.model.ServiceUpdateSeverity.wrap(value)
        )
    override val serviceUpdateRecommendedApplyByDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateRecommendedApplyByDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateStatus
        : Optional[zio.aws.elasticache.model.ServiceUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateStatus())
        .map(value => zio.aws.elasticache.model.ServiceUpdateStatus.wrap(value))
    override val serviceUpdateDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateDescription())
        .map(value => value: String)
    override val serviceUpdateType
        : Optional[zio.aws.elasticache.model.ServiceUpdateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateType())
        .map(value => zio.aws.elasticache.model.ServiceUpdateType.wrap(value))
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoUpdateAfterRecommendedApplyByDate
        : Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpdateAfterRecommendedApplyByDate())
      .map(value => value: BooleanOptional)
    override val estimatedUpdateTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.estimatedUpdateTime())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ServiceUpdate
  ): zio.aws.elasticache.model.ServiceUpdate.ReadOnly = new Wrapper(impl)
}
