package zio.aws.elasticache
import zio.aws.elasticache.model.BatchStopUpdateActionResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.elasticache.{
  ElastiCacheAsyncClientBuilder,
  ElastiCacheAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.elasticache.model.{
  DeleteUserRequest,
  DescribeReservedCacheNodesRequest,
  DescribeUsersRequest,
  ModifyCacheParameterGroupRequest,
  AuthorizeCacheSecurityGroupIngressRequest,
  DescribeSnapshotsRequest,
  DescribeEngineDefaultParametersRequest,
  DeleteSnapshotRequest,
  AddTagsToResourceRequest,
  DeleteGlobalReplicationGroupRequest,
  DescribeGlobalReplicationGroupsRequest,
  DescribeCacheParameterGroupsRequest,
  DisassociateGlobalReplicationGroupRequest,
  DecreaseReplicaCountRequest,
  DescribeCacheEngineVersionsRequest,
  DeleteCacheClusterRequest,
  ListAllowedNodeTypeModificationsRequest,
  DescribeEventsRequest,
  RebalanceSlotsInGlobalReplicationGroupRequest,
  PurchaseReservedCacheNodesOfferingRequest,
  ListTagsForResourceRequest,
  ModifyGlobalReplicationGroupRequest,
  CreateUserGroupRequest,
  CopySnapshotRequest,
  DescribeCacheClustersRequest,
  CreateCacheSubnetGroupRequest,
  DescribeCacheSubnetGroupsRequest,
  ModifyUserRequest,
  IncreaseReplicaCountRequest,
  CreateGlobalReplicationGroupRequest,
  CreateCacheClusterRequest,
  RebootCacheClusterRequest,
  ModifyUserGroupRequest,
  DescribeReservedCacheNodesOfferingsRequest,
  DecreaseNodeGroupsInGlobalReplicationGroupRequest,
  RevokeCacheSecurityGroupIngressRequest,
  CreateUserRequest,
  DescribeServiceUpdatesRequest,
  DescribeCacheSecurityGroupsRequest,
  BatchApplyUpdateActionRequest,
  TestFailoverRequest,
  ModifyCacheSubnetGroupRequest,
  RemoveTagsFromResourceRequest,
  CreateCacheSecurityGroupRequest,
  ModifyReplicationGroupShardConfigurationRequest,
  CreateReplicationGroupRequest,
  DescribeUpdateActionsRequest,
  ModifyReplicationGroupRequest,
  DescribeCacheParametersRequest,
  CompleteMigrationRequest,
  BatchStopUpdateActionRequest,
  ModifyCacheClusterRequest,
  CreateSnapshotRequest,
  DescribeUserGroupsRequest,
  CreateCacheParameterGroupRequest,
  DeleteReplicationGroupRequest,
  IncreaseNodeGroupsInGlobalReplicationGroupRequest,
  DeleteCacheSecurityGroupRequest,
  DeleteCacheSubnetGroupRequest,
  FailoverGlobalReplicationGroupRequest,
  ResetCacheParameterGroupRequest,
  DeleteCacheParameterGroupRequest,
  StartMigrationRequest,
  DescribeReplicationGroupsRequest,
  DeleteUserGroupRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.elasticache.paginators.{
  DescribeReservedCacheNodesOfferingsPublisher,
  DescribeReservedCacheNodesPublisher,
  DescribeUserGroupsPublisher,
  DescribeReplicationGroupsPublisher,
  DescribeCacheSubnetGroupsPublisher,
  DescribeServiceUpdatesPublisher,
  DescribeGlobalReplicationGroupsPublisher,
  DescribeCacheParametersPublisher,
  DescribeUpdateActionsPublisher,
  DescribeSnapshotsPublisher,
  DescribeCacheEngineVersionsPublisher,
  DescribeEventsPublisher,
  DescribeCacheParameterGroupsPublisher,
  DescribeUsersPublisher,
  DescribeCacheClustersPublisher,
  DescribeCacheSecurityGroupsPublisher
}
import software.amazon.awssdk.services.elasticache.model.{
  DescribeCacheClustersResponse,
  TestFailoverResponse,
  CacheSecurityGroup,
  DescribeEventsResponse,
  ModifyUserResponse,
  DeleteReplicationGroupResponse,
  DeleteUserGroupResponse,
  ResetCacheParameterGroupResponse,
  IncreaseNodeGroupsInGlobalReplicationGroupResponse,
  DescribeSnapshotsResponse,
  ListAllowedNodeTypeModificationsResponse,
  RemoveTagsFromResourceResponse,
  CreateReplicationGroupResponse,
  DescribeEngineDefaultParametersResponse,
  IncreaseReplicaCountResponse,
  User,
  CacheCluster,
  ModifyCacheSubnetGroupResponse,
  DeleteCacheSubnetGroupResponse,
  CreateCacheSubnetGroupResponse,
  BatchApplyUpdateActionResponse,
  DescribeCacheSubnetGroupsResponse,
  DescribeUserGroupsResponse,
  CreateCacheParameterGroupResponse,
  ModifyGlobalReplicationGroupResponse,
  DescribeCacheParametersResponse,
  FailoverGlobalReplicationGroupResponse,
  CacheSubnetGroup,
  Snapshot,
  ListTagsForResourceResponse,
  DescribeUpdateActionsResponse,
  CreateCacheSecurityGroupResponse,
  DeleteCacheClusterResponse,
  CacheEngineVersion,
  DescribeGlobalReplicationGroupsResponse,
  DescribeCacheParameterGroupsResponse,
  UserGroup,
  RebootCacheClusterResponse,
  DescribeReservedCacheNodesOfferingsResponse,
  GlobalReplicationGroup,
  CreateUserResponse,
  RebalanceSlotsInGlobalReplicationGroupResponse,
  DescribeUsersResponse,
  DescribeServiceUpdatesResponse,
  CacheParameterGroup,
  CreateCacheClusterResponse,
  ModifyCacheParameterGroupResponse,
  ModifyUserGroupResponse,
  BatchStopUpdateActionResponse,
  CopySnapshotResponse,
  DecreaseNodeGroupsInGlobalReplicationGroupResponse,
  DeleteGlobalReplicationGroupResponse,
  DeleteCacheParameterGroupResponse,
  ServiceUpdate,
  DeleteCacheSecurityGroupResponse,
  ReservedCacheNode,
  DescribeCacheSecurityGroupsResponse,
  DeleteUserResponse,
  CreateUserGroupResponse,
  ReplicationGroup,
  AddTagsToResourceResponse,
  RevokeCacheSecurityGroupIngressResponse,
  AuthorizeCacheSecurityGroupIngressResponse,
  DecreaseReplicaCountResponse,
  Event,
  ModifyReplicationGroupResponse,
  CompleteMigrationResponse,
  UpdateAction,
  StartMigrationResponse,
  PurchaseReservedCacheNodesOfferingResponse,
  ModifyCacheClusterResponse,
  Parameter,
  DisassociateGlobalReplicationGroupResponse,
  ReservedCacheNodesOffering,
  CreateSnapshotResponse,
  DeleteSnapshotResponse,
  CreateGlobalReplicationGroupResponse,
  DescribeReplicationGroupsResponse,
  ModifyReplicationGroupShardConfigurationResponse,
  DescribeReservedCacheNodesResponse,
  DescribeCacheEngineVersionsResponse
}
import scala.jdk.CollectionConverters.*
trait ElastiCache extends AspectSupport[ElastiCache] {
  val api: ElastiCacheAsyncClient
  def describeEngineDefaultParameters(
      request: DescribeEngineDefaultParametersRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.ReadOnly
  ]
  def describeCacheSecurityGroups(
      request: DescribeCacheSecurityGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
  ]
  def describeCacheSecurityGroupsPaginated(
      request: DescribeCacheSecurityGroupsRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.ReadOnly
  ]
  def resetCacheParameterGroup(request: ResetCacheParameterGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.ResetCacheParameterGroupResponse.ReadOnly
  ]
  def describeCacheParameters(
      request: DescribeCacheParametersRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.Parameter.ReadOnly]
  def describeCacheParametersPaginated(
      request: DescribeCacheParametersRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeCacheParametersResponse.ReadOnly
  ]
  def addTagsToResource(
      request: AddTagsToResourceRequest
  ): IO[AwsError, zio.aws.elasticache.model.AddTagsToResourceResponse.ReadOnly]
  def createCacheParameterGroup(request: CreateCacheParameterGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.CreateCacheParameterGroupResponse.ReadOnly
  ]
  def createGlobalReplicationGroup(
      request: CreateGlobalReplicationGroupRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.ReadOnly
  ]
  def deleteCacheParameterGroup(
      request: DeleteCacheParameterGroupRequest
  ): IO[AwsError, Unit]
  def completeMigration(
      request: CompleteMigrationRequest
  ): IO[AwsError, zio.aws.elasticache.model.CompleteMigrationResponse.ReadOnly]
  def deleteGlobalReplicationGroup(
      request: DeleteGlobalReplicationGroupRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.ReadOnly
  ]
  def describeCacheParameterGroups(
      request: DescribeCacheParameterGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticache.model.CacheParameterGroup.ReadOnly
  ]
  def describeCacheParameterGroupsPaginated(
      request: DescribeCacheParameterGroupsRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.ReadOnly
  ]
  def increaseReplicaCount(request: IncreaseReplicaCountRequest): IO[
    AwsError,
    zio.aws.elasticache.model.IncreaseReplicaCountResponse.ReadOnly
  ]
  def modifyUser(
      request: ModifyUserRequest
  ): IO[AwsError, zio.aws.elasticache.model.ModifyUserResponse.ReadOnly]
  def describeCacheEngineVersions(
      request: DescribeCacheEngineVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticache.model.CacheEngineVersion.ReadOnly
  ]
  def describeCacheEngineVersionsPaginated(
      request: DescribeCacheEngineVersionsRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.ReadOnly
  ]
  def listAllowedNodeTypeModifications(
      request: ListAllowedNodeTypeModificationsRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.ReadOnly
  ]
  def deleteReplicationGroup(request: DeleteReplicationGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.DeleteReplicationGroupResponse.ReadOnly
  ]
  def createReplicationGroup(request: CreateReplicationGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.CreateReplicationGroupResponse.ReadOnly
  ]
  def describeCacheSubnetGroups(
      request: DescribeCacheSubnetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly]
  def describeCacheSubnetGroupsPaginated(
      request: DescribeCacheSubnetGroupsRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly
  ]
  def modifyCacheSubnetGroup(request: ModifyCacheSubnetGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.ReadOnly
  ]
  def modifyReplicationGroup(request: ModifyReplicationGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.ModifyReplicationGroupResponse.ReadOnly
  ]
  def copySnapshot(
      request: CopySnapshotRequest
  ): IO[AwsError, zio.aws.elasticache.model.CopySnapshotResponse.ReadOnly]
  def purchaseReservedCacheNodesOffering(
      request: PurchaseReservedCacheNodesOfferingRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.ReadOnly
  ]
  def increaseNodeGroupsInGlobalReplicationGroup(
      request: IncreaseNodeGroupsInGlobalReplicationGroupRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
  ]
  def removeTagsFromResource(request: RemoveTagsFromResourceRequest): IO[
    AwsError,
    zio.aws.elasticache.model.RemoveTagsFromResourceResponse.ReadOnly
  ]
  def decreaseReplicaCount(request: DecreaseReplicaCountRequest): IO[
    AwsError,
    zio.aws.elasticache.model.DecreaseReplicaCountResponse.ReadOnly
  ]
  def rebalanceSlotsInGlobalReplicationGroup(
      request: RebalanceSlotsInGlobalReplicationGroupRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.ReadOnly
  ]
  def describeUpdateActions(
      request: DescribeUpdateActionsRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.UpdateAction.ReadOnly]
  def describeUpdateActionsPaginated(request: DescribeUpdateActionsRequest): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly
  ]
  def createUser(
      request: CreateUserRequest
  ): IO[AwsError, zio.aws.elasticache.model.CreateUserResponse.ReadOnly]
  def authorizeCacheSecurityGroupIngress(
      request: AuthorizeCacheSecurityGroupIngressRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.ReadOnly
  ]
  def deleteCacheSubnetGroup(
      request: DeleteCacheSubnetGroupRequest
  ): IO[AwsError, Unit]
  def deleteSnapshot(
      request: DeleteSnapshotRequest
  ): IO[AwsError, zio.aws.elasticache.model.DeleteSnapshotResponse.ReadOnly]
  def describeReplicationGroups(
      request: DescribeReplicationGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.ReplicationGroup.ReadOnly]
  def describeReplicationGroupsPaginated(
      request: DescribeReplicationGroupsRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly
  ]
  def describeReservedCacheNodes(
      request: DescribeReservedCacheNodesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticache.model.ReservedCacheNode.ReadOnly
  ]
  def describeReservedCacheNodesPaginated(
      request: DescribeReservedCacheNodesRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly
  ]
  def describeServiceUpdates(
      request: DescribeServiceUpdatesRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.ServiceUpdate.ReadOnly]
  def describeServiceUpdatesPaginated(
      request: DescribeServiceUpdatesRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeServiceUpdatesResponse.ReadOnly
  ]
  def modifyUserGroup(
      request: ModifyUserGroupRequest
  ): IO[AwsError, zio.aws.elasticache.model.ModifyUserGroupResponse.ReadOnly]
  def describeUsers(
      request: DescribeUsersRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.User.ReadOnly]
  def describeUsersPaginated(
      request: DescribeUsersRequest
  ): IO[AwsError, zio.aws.elasticache.model.DescribeUsersResponse.ReadOnly]
  def createCacheSecurityGroup(request: CreateCacheSecurityGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.ReadOnly
  ]
  def batchApplyUpdateAction(request: BatchApplyUpdateActionRequest): IO[
    AwsError,
    zio.aws.elasticache.model.BatchApplyUpdateActionResponse.ReadOnly
  ]
  def createCacheCluster(
      request: CreateCacheClusterRequest
  ): IO[AwsError, zio.aws.elasticache.model.CreateCacheClusterResponse.ReadOnly]
  def deleteCacheSecurityGroup(
      request: DeleteCacheSecurityGroupRequest
  ): IO[AwsError, Unit]
  def describeGlobalReplicationGroups(
      request: DescribeGlobalReplicationGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
  ]
  def describeGlobalReplicationGroupsPaginated(
      request: DescribeGlobalReplicationGroupsRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.ReadOnly
  ]
  def disassociateGlobalReplicationGroup(
      request: DisassociateGlobalReplicationGroupRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DisassociateGlobalReplicationGroupResponse.ReadOnly
  ]
  def describeReservedCacheNodesOfferings(
      request: DescribeReservedCacheNodesOfferingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly
  ]
  def describeReservedCacheNodesOfferingsPaginated(
      request: DescribeReservedCacheNodesOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly
  ]
  def describeSnapshots(
      request: DescribeSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.Snapshot.ReadOnly]
  def describeSnapshotsPaginated(
      request: DescribeSnapshotsRequest
  ): IO[AwsError, zio.aws.elasticache.model.DescribeSnapshotsResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.elasticache.model.ListTagsForResourceResponse.ReadOnly
  ]
  def rebootCacheCluster(
      request: RebootCacheClusterRequest
  ): IO[AwsError, zio.aws.elasticache.model.RebootCacheClusterResponse.ReadOnly]
  def deleteUser(
      request: DeleteUserRequest
  ): IO[AwsError, zio.aws.elasticache.model.DeleteUserResponse.ReadOnly]
  def deleteUserGroup(
      request: DeleteUserGroupRequest
  ): IO[AwsError, zio.aws.elasticache.model.DeleteUserGroupResponse.ReadOnly]
  def revokeCacheSecurityGroupIngress(
      request: RevokeCacheSecurityGroupIngressRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.ReadOnly
  ]
  def startMigration(
      request: StartMigrationRequest
  ): IO[AwsError, zio.aws.elasticache.model.StartMigrationResponse.ReadOnly]
  def createCacheSubnetGroup(request: CreateCacheSubnetGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.ReadOnly
  ]
  def failoverGlobalReplicationGroup(
      request: FailoverGlobalReplicationGroupRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.ReadOnly
  ]
  def batchStopUpdateAction(
      request: BatchStopUpdateActionRequest
  ): IO[AwsError, ReadOnly]
  def describeCacheClusters(
      request: DescribeCacheClustersRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.CacheCluster.ReadOnly]
  def describeCacheClustersPaginated(request: DescribeCacheClustersRequest): IO[
    AwsError,
    zio.aws.elasticache.model.DescribeCacheClustersResponse.ReadOnly
  ]
  def createUserGroup(
      request: CreateUserGroupRequest
  ): IO[AwsError, zio.aws.elasticache.model.CreateUserGroupResponse.ReadOnly]
  def describeUserGroups(
      request: DescribeUserGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.UserGroup.ReadOnly]
  def describeUserGroupsPaginated(
      request: DescribeUserGroupsRequest
  ): IO[AwsError, zio.aws.elasticache.model.DescribeUserGroupsResponse.ReadOnly]
  def modifyCacheParameterGroup(request: ModifyCacheParameterGroupRequest): IO[
    AwsError,
    zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.ReadOnly
  ]
  def modifyCacheCluster(
      request: ModifyCacheClusterRequest
  ): IO[AwsError, zio.aws.elasticache.model.ModifyCacheClusterResponse.ReadOnly]
  def testFailover(
      request: TestFailoverRequest
  ): IO[AwsError, zio.aws.elasticache.model.TestFailoverResponse.ReadOnly]
  def modifyGlobalReplicationGroup(
      request: ModifyGlobalReplicationGroupRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.ModifyGlobalReplicationGroupResponse.ReadOnly
  ]
  def deleteCacheCluster(
      request: DeleteCacheClusterRequest
  ): IO[AwsError, zio.aws.elasticache.model.DeleteCacheClusterResponse.ReadOnly]
  def modifyReplicationGroupShardConfiguration(
      request: ModifyReplicationGroupShardConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.ReadOnly
  ]
  def createSnapshot(
      request: CreateSnapshotRequest
  ): IO[AwsError, zio.aws.elasticache.model.CreateSnapshotResponse.ReadOnly]
  def describeEvents(
      request: DescribeEventsRequest
  ): ZStream[Any, AwsError, zio.aws.elasticache.model.Event.ReadOnly]
  def describeEventsPaginated(
      request: DescribeEventsRequest
  ): IO[AwsError, zio.aws.elasticache.model.DescribeEventsResponse.ReadOnly]
  def decreaseNodeGroupsInGlobalReplicationGroup(
      request: DecreaseNodeGroupsInGlobalReplicationGroupRequest
  ): IO[
    AwsError,
    zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
  ]
}
object ElastiCache {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ElastiCache] = customized(
    identity
  )
  def customized(
      customization: ElastiCacheAsyncClientBuilder => ElastiCacheAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ElastiCache] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ElastiCacheAsyncClientBuilder => ElastiCacheAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ElastiCache] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ElastiCacheAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ElastiCacheAsyncClient, ElastiCacheAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ElastiCacheAsyncClient,
      ElastiCacheAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ElastiCacheImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ElastiCacheImpl[R](
      override val api: ElastiCacheAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ElastiCache
      with AwsServiceBase[R] {
    override val serviceName: String = "ElastiCache"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ElastiCacheImpl[R1] = new ElastiCacheImpl(api, newAspect, r)
    def describeEngineDefaultParameters(
        request: DescribeEngineDefaultParametersRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest,
      DescribeEngineDefaultParametersResponse
    ]("describeEngineDefaultParameters", api.describeEngineDefaultParameters)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.wrap
    ).provideEnvironment(r)
    def describeCacheSecurityGroups(
        request: DescribeCacheSecurityGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest,
      CacheSecurityGroup,
      DescribeCacheSecurityGroupsPublisher
    ](
      "describeCacheSecurityGroups",
      api.describeCacheSecurityGroupsPaginator,
      _.cacheSecurityGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticache.model.CacheSecurityGroup.wrap(item))
      .provideEnvironment(r)
    def describeCacheSecurityGroupsPaginated(
        request: DescribeCacheSecurityGroupsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest,
      DescribeCacheSecurityGroupsResponse
    ]("describeCacheSecurityGroups", api.describeCacheSecurityGroups)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.wrap)
      .provideEnvironment(r)
    def resetCacheParameterGroup(request: ResetCacheParameterGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.ResetCacheParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest,
      ResetCacheParameterGroupResponse
    ]("resetCacheParameterGroup", api.resetCacheParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.ResetCacheParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def describeCacheParameters(
        request: DescribeCacheParametersRequest
    ): ZStream[Any, AwsError, zio.aws.elasticache.model.Parameter.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest,
        Parameter,
        DescribeCacheParametersPublisher
      ](
        "describeCacheParameters",
        api.describeCacheParametersPaginator,
        _.parameters()
      )(request.buildAwsValue())
        .map(item => zio.aws.elasticache.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeCacheParametersPaginated(
        request: DescribeCacheParametersRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeCacheParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest,
      DescribeCacheParametersResponse
    ]("describeCacheParameters", api.describeCacheParameters)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeCacheParametersResponse.wrap)
      .provideEnvironment(r)
    def addTagsToResource(request: AddTagsToResourceRequest): IO[
      AwsError,
      zio.aws.elasticache.model.AddTagsToResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.AddTagsToResourceRequest,
      AddTagsToResourceResponse
    ]("addTagsToResource", api.addTagsToResource)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.AddTagsToResourceResponse.wrap)
      .provideEnvironment(r)
    def createCacheParameterGroup(
        request: CreateCacheParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.CreateCacheParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest,
      CreateCacheParameterGroupResponse
    ]("createCacheParameterGroup", api.createCacheParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.CreateCacheParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def createGlobalReplicationGroup(
        request: CreateGlobalReplicationGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest,
      CreateGlobalReplicationGroupResponse
    ]("createGlobalReplicationGroup", api.createGlobalReplicationGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteCacheParameterGroup(
        request: DeleteCacheParameterGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest,
      DeleteCacheParameterGroupResponse
    ]("deleteCacheParameterGroup", api.deleteCacheParameterGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def completeMigration(request: CompleteMigrationRequest): IO[
      AwsError,
      zio.aws.elasticache.model.CompleteMigrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest,
      CompleteMigrationResponse
    ]("completeMigration", api.completeMigration)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.CompleteMigrationResponse.wrap)
      .provideEnvironment(r)
    def deleteGlobalReplicationGroup(
        request: DeleteGlobalReplicationGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest,
      DeleteGlobalReplicationGroupResponse
    ]("deleteGlobalReplicationGroup", api.deleteGlobalReplicationGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.wrap)
      .provideEnvironment(r)
    def describeCacheParameterGroups(
        request: DescribeCacheParameterGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheParameterGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest,
      CacheParameterGroup,
      DescribeCacheParameterGroupsPublisher
    ](
      "describeCacheParameterGroups",
      api.describeCacheParameterGroupsPaginator,
      _.cacheParameterGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticache.model.CacheParameterGroup.wrap(item))
      .provideEnvironment(r)
    def describeCacheParameterGroupsPaginated(
        request: DescribeCacheParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest,
      DescribeCacheParameterGroupsResponse
    ]("describeCacheParameterGroups", api.describeCacheParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.wrap)
      .provideEnvironment(r)
    def increaseReplicaCount(request: IncreaseReplicaCountRequest): IO[
      AwsError,
      zio.aws.elasticache.model.IncreaseReplicaCountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest,
      IncreaseReplicaCountResponse
    ]("increaseReplicaCount", api.increaseReplicaCount)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.IncreaseReplicaCountResponse.wrap)
      .provideEnvironment(r)
    def modifyUser(
        request: ModifyUserRequest
    ): IO[AwsError, zio.aws.elasticache.model.ModifyUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.ModifyUserRequest,
        ModifyUserResponse
      ]("modifyUser", api.modifyUser)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.ModifyUserResponse.wrap)
        .provideEnvironment(r)
    def describeCacheEngineVersions(
        request: DescribeCacheEngineVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheEngineVersion.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest,
      CacheEngineVersion,
      DescribeCacheEngineVersionsPublisher
    ](
      "describeCacheEngineVersions",
      api.describeCacheEngineVersionsPaginator,
      _.cacheEngineVersions()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticache.model.CacheEngineVersion.wrap(item))
      .provideEnvironment(r)
    def describeCacheEngineVersionsPaginated(
        request: DescribeCacheEngineVersionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest,
      DescribeCacheEngineVersionsResponse
    ]("describeCacheEngineVersions", api.describeCacheEngineVersions)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.wrap)
      .provideEnvironment(r)
    def listAllowedNodeTypeModifications(
        request: ListAllowedNodeTypeModificationsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest,
      ListAllowedNodeTypeModificationsResponse
    ]("listAllowedNodeTypeModifications", api.listAllowedNodeTypeModifications)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.wrap
    ).provideEnvironment(r)
    def deleteReplicationGroup(request: DeleteReplicationGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.DeleteReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest,
      DeleteReplicationGroupResponse
    ]("deleteReplicationGroup", api.deleteReplicationGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DeleteReplicationGroupResponse.wrap)
      .provideEnvironment(r)
    def createReplicationGroup(request: CreateReplicationGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.CreateReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest,
      CreateReplicationGroupResponse
    ]("createReplicationGroup", api.createReplicationGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.CreateReplicationGroupResponse.wrap)
      .provideEnvironment(r)
    def describeCacheSubnetGroups(
        request: DescribeCacheSubnetGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest,
      CacheSubnetGroup,
      DescribeCacheSubnetGroupsPublisher
    ](
      "describeCacheSubnetGroups",
      api.describeCacheSubnetGroupsPaginator,
      _.cacheSubnetGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticache.model.CacheSubnetGroup.wrap(item))
      .provideEnvironment(r)
    def describeCacheSubnetGroupsPaginated(
        request: DescribeCacheSubnetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest,
      DescribeCacheSubnetGroupsResponse
    ]("describeCacheSubnetGroups", api.describeCacheSubnetGroups)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.wrap)
      .provideEnvironment(r)
    def modifyCacheSubnetGroup(request: ModifyCacheSubnetGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest,
      ModifyCacheSubnetGroupResponse
    ]("modifyCacheSubnetGroup", api.modifyCacheSubnetGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.wrap)
      .provideEnvironment(r)
    def modifyReplicationGroup(request: ModifyReplicationGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.ModifyReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest,
      ModifyReplicationGroupResponse
    ]("modifyReplicationGroup", api.modifyReplicationGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.ModifyReplicationGroupResponse.wrap)
      .provideEnvironment(r)
    def copySnapshot(
        request: CopySnapshotRequest
    ): IO[AwsError, zio.aws.elasticache.model.CopySnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest,
        CopySnapshotResponse
      ]("copySnapshot", api.copySnapshot)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.CopySnapshotResponse.wrap)
        .provideEnvironment(r)
    def purchaseReservedCacheNodesOffering(
        request: PurchaseReservedCacheNodesOfferingRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest,
      PurchaseReservedCacheNodesOfferingResponse
    ](
      "purchaseReservedCacheNodesOffering",
      api.purchaseReservedCacheNodesOffering
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.wrap
      )
      .provideEnvironment(r)
    def increaseNodeGroupsInGlobalReplicationGroup(
        request: IncreaseNodeGroupsInGlobalReplicationGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest,
      IncreaseNodeGroupsInGlobalReplicationGroupResponse
    ](
      "increaseNodeGroupsInGlobalReplicationGroup",
      api.increaseNodeGroupsInGlobalReplicationGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse.wrap
      )
      .provideEnvironment(r)
    def removeTagsFromResource(request: RemoveTagsFromResourceRequest): IO[
      AwsError,
      zio.aws.elasticache.model.RemoveTagsFromResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest,
      RemoveTagsFromResourceResponse
    ]("removeTagsFromResource", api.removeTagsFromResource)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.RemoveTagsFromResourceResponse.wrap)
      .provideEnvironment(r)
    def decreaseReplicaCount(request: DecreaseReplicaCountRequest): IO[
      AwsError,
      zio.aws.elasticache.model.DecreaseReplicaCountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest,
      DecreaseReplicaCountResponse
    ]("decreaseReplicaCount", api.decreaseReplicaCount)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.DecreaseReplicaCountResponse.wrap)
      .provideEnvironment(r)
    def rebalanceSlotsInGlobalReplicationGroup(
        request: RebalanceSlotsInGlobalReplicationGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest,
      RebalanceSlotsInGlobalReplicationGroupResponse
    ](
      "rebalanceSlotsInGlobalReplicationGroup",
      api.rebalanceSlotsInGlobalReplicationGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.wrap
      )
      .provideEnvironment(r)
    def describeUpdateActions(
        request: DescribeUpdateActionsRequest
    ): ZStream[Any, AwsError, zio.aws.elasticache.model.UpdateAction.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest,
        UpdateAction,
        DescribeUpdateActionsPublisher
      ](
        "describeUpdateActions",
        api.describeUpdateActionsPaginator,
        _.updateActions()
      )(request.buildAwsValue())
        .map(item => zio.aws.elasticache.model.UpdateAction.wrap(item))
        .provideEnvironment(r)
    def describeUpdateActionsPaginated(
        request: DescribeUpdateActionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest,
      DescribeUpdateActionsResponse
    ]("describeUpdateActions", api.describeUpdateActions)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeUpdateActionsResponse.wrap)
      .provideEnvironment(r)
    def createUser(
        request: CreateUserRequest
    ): IO[AwsError, zio.aws.elasticache.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.CreateUserRequest,
        CreateUserResponse
      ]("createUser", api.createUser)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def authorizeCacheSecurityGroupIngress(
        request: AuthorizeCacheSecurityGroupIngressRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest,
      AuthorizeCacheSecurityGroupIngressResponse
    ](
      "authorizeCacheSecurityGroupIngress",
      api.authorizeCacheSecurityGroupIngress
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.wrap
      )
      .provideEnvironment(r)
    def deleteCacheSubnetGroup(
        request: DeleteCacheSubnetGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest,
      DeleteCacheSubnetGroupResponse
    ]("deleteCacheSubnetGroup", api.deleteCacheSubnetGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteSnapshot(
        request: DeleteSnapshotRequest
    ): IO[AwsError, zio.aws.elasticache.model.DeleteSnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest,
        DeleteSnapshotResponse
      ]("deleteSnapshot", api.deleteSnapshot)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.DeleteSnapshotResponse.wrap)
        .provideEnvironment(r)
    def describeReplicationGroups(
        request: DescribeReplicationGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReplicationGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest,
      ReplicationGroup,
      DescribeReplicationGroupsPublisher
    ](
      "describeReplicationGroups",
      api.describeReplicationGroupsPaginator,
      _.replicationGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticache.model.ReplicationGroup.wrap(item))
      .provideEnvironment(r)
    def describeReplicationGroupsPaginated(
        request: DescribeReplicationGroupsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest,
      DescribeReplicationGroupsResponse
    ]("describeReplicationGroups", api.describeReplicationGroups)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeReplicationGroupsResponse.wrap)
      .provideEnvironment(r)
    def describeReservedCacheNodes(
        request: DescribeReservedCacheNodesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReservedCacheNode.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest,
      ReservedCacheNode,
      DescribeReservedCacheNodesPublisher
    ](
      "describeReservedCacheNodes",
      api.describeReservedCacheNodesPaginator,
      _.reservedCacheNodes()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticache.model.ReservedCacheNode.wrap(item))
      .provideEnvironment(r)
    def describeReservedCacheNodesPaginated(
        request: DescribeReservedCacheNodesRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest,
      DescribeReservedCacheNodesResponse
    ]("describeReservedCacheNodes", api.describeReservedCacheNodes)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.wrap)
      .provideEnvironment(r)
    def describeServiceUpdates(request: DescribeServiceUpdatesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.ServiceUpdate.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest,
      ServiceUpdate,
      DescribeServiceUpdatesPublisher
    ](
      "describeServiceUpdates",
      api.describeServiceUpdatesPaginator,
      _.serviceUpdates()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticache.model.ServiceUpdate.wrap(item))
      .provideEnvironment(r)
    def describeServiceUpdatesPaginated(
        request: DescribeServiceUpdatesRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeServiceUpdatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest,
      DescribeServiceUpdatesResponse
    ]("describeServiceUpdates", api.describeServiceUpdates)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeServiceUpdatesResponse.wrap)
      .provideEnvironment(r)
    def modifyUserGroup(request: ModifyUserGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.ModifyUserGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest,
      ModifyUserGroupResponse
    ]("modifyUserGroup", api.modifyUserGroup)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.ModifyUserGroupResponse.wrap)
      .provideEnvironment(r)
    def describeUsers(
        request: DescribeUsersRequest
    ): ZStream[Any, AwsError, zio.aws.elasticache.model.User.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest,
        User,
        DescribeUsersPublisher
      ]("describeUsers", api.describeUsersPaginator, _.users())(
        request.buildAwsValue()
      ).map(item => zio.aws.elasticache.model.User.wrap(item))
        .provideEnvironment(r)
    def describeUsersPaginated(
        request: DescribeUsersRequest
    ): IO[AwsError, zio.aws.elasticache.model.DescribeUsersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest,
        DescribeUsersResponse
      ]("describeUsers", api.describeUsers)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.DescribeUsersResponse.wrap)
        .provideEnvironment(r)
    def createCacheSecurityGroup(request: CreateCacheSecurityGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest,
      CreateCacheSecurityGroupResponse
    ]("createCacheSecurityGroup", api.createCacheSecurityGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.wrap)
      .provideEnvironment(r)
    def batchApplyUpdateAction(request: BatchApplyUpdateActionRequest): IO[
      AwsError,
      zio.aws.elasticache.model.BatchApplyUpdateActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest,
      BatchApplyUpdateActionResponse
    ]("batchApplyUpdateAction", api.batchApplyUpdateAction)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.BatchApplyUpdateActionResponse.wrap)
      .provideEnvironment(r)
    def createCacheCluster(request: CreateCacheClusterRequest): IO[
      AwsError,
      zio.aws.elasticache.model.CreateCacheClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest,
      CreateCacheClusterResponse
    ]("createCacheCluster", api.createCacheCluster)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.CreateCacheClusterResponse.wrap)
      .provideEnvironment(r)
    def deleteCacheSecurityGroup(
        request: DeleteCacheSecurityGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest,
      DeleteCacheSecurityGroupResponse
    ]("deleteCacheSecurityGroup", api.deleteCacheSecurityGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeGlobalReplicationGroups(
        request: DescribeGlobalReplicationGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest,
      GlobalReplicationGroup,
      DescribeGlobalReplicationGroupsPublisher
    ](
      "describeGlobalReplicationGroups",
      api.describeGlobalReplicationGroupsPaginator,
      _.globalReplicationGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticache.model.GlobalReplicationGroup.wrap(item))
      .provideEnvironment(r)
    def describeGlobalReplicationGroupsPaginated(
        request: DescribeGlobalReplicationGroupsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest,
      DescribeGlobalReplicationGroupsResponse
    ]("describeGlobalReplicationGroups", api.describeGlobalReplicationGroups)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.wrap
    ).provideEnvironment(r)
    def disassociateGlobalReplicationGroup(
        request: DisassociateGlobalReplicationGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DisassociateGlobalReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest,
      DisassociateGlobalReplicationGroupResponse
    ](
      "disassociateGlobalReplicationGroup",
      api.disassociateGlobalReplicationGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticache.model.DisassociateGlobalReplicationGroupResponse.wrap
      )
      .provideEnvironment(r)
    def describeReservedCacheNodesOfferings(
        request: DescribeReservedCacheNodesOfferingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest,
      ReservedCacheNodesOffering,
      DescribeReservedCacheNodesOfferingsPublisher
    ](
      "describeReservedCacheNodesOfferings",
      api.describeReservedCacheNodesOfferingsPaginator,
      _.reservedCacheNodesOfferings()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticache.model.ReservedCacheNodesOffering.wrap(item)
      )
      .provideEnvironment(r)
    def describeReservedCacheNodesOfferingsPaginated(
        request: DescribeReservedCacheNodesOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest,
      DescribeReservedCacheNodesOfferingsResponse
    ](
      "describeReservedCacheNodesOfferings",
      api.describeReservedCacheNodesOfferings
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.wrap
      )
      .provideEnvironment(r)
    def describeSnapshots(request: DescribeSnapshotsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticache.model.Snapshot.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest,
      Snapshot,
      DescribeSnapshotsPublisher
    ]("describeSnapshots", api.describeSnapshotsPaginator, _.snapshots())(
      request.buildAwsValue()
    ).map(item => zio.aws.elasticache.model.Snapshot.wrap(item))
      .provideEnvironment(r)
    def describeSnapshotsPaginated(request: DescribeSnapshotsRequest): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest,
      DescribeSnapshotsResponse
    ]("describeSnapshots", api.describeSnapshots)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.DescribeSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.elasticache.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def rebootCacheCluster(request: RebootCacheClusterRequest): IO[
      AwsError,
      zio.aws.elasticache.model.RebootCacheClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest,
      RebootCacheClusterResponse
    ]("rebootCacheCluster", api.rebootCacheCluster)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.RebootCacheClusterResponse.wrap)
      .provideEnvironment(r)
    def deleteUser(
        request: DeleteUserRequest
    ): IO[AwsError, zio.aws.elasticache.model.DeleteUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.DeleteUserRequest,
        DeleteUserResponse
      ]("deleteUser", api.deleteUser)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.DeleteUserResponse.wrap)
        .provideEnvironment(r)
    def deleteUserGroup(request: DeleteUserGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.DeleteUserGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest,
      DeleteUserGroupResponse
    ]("deleteUserGroup", api.deleteUserGroup)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.DeleteUserGroupResponse.wrap)
      .provideEnvironment(r)
    def revokeCacheSecurityGroupIngress(
        request: RevokeCacheSecurityGroupIngressRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest,
      RevokeCacheSecurityGroupIngressResponse
    ]("revokeCacheSecurityGroupIngress", api.revokeCacheSecurityGroupIngress)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.wrap
    ).provideEnvironment(r)
    def startMigration(
        request: StartMigrationRequest
    ): IO[AwsError, zio.aws.elasticache.model.StartMigrationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.StartMigrationRequest,
        StartMigrationResponse
      ]("startMigration", api.startMigration)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.StartMigrationResponse.wrap)
        .provideEnvironment(r)
    def createCacheSubnetGroup(request: CreateCacheSubnetGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest,
      CreateCacheSubnetGroupResponse
    ]("createCacheSubnetGroup", api.createCacheSubnetGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.wrap)
      .provideEnvironment(r)
    def failoverGlobalReplicationGroup(
        request: FailoverGlobalReplicationGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest,
      FailoverGlobalReplicationGroupResponse
    ]("failoverGlobalReplicationGroup", api.failoverGlobalReplicationGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.wrap)
      .provideEnvironment(r)
    def batchStopUpdateAction(
        request: BatchStopUpdateActionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest,
      BatchStopUpdateActionResponse
    ]("batchStopUpdateAction", api.batchStopUpdateAction)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.BatchStopUpdateActionResponse.wrap)
      .provideEnvironment(r)
    def describeCacheClusters(
        request: DescribeCacheClustersRequest
    ): ZStream[Any, AwsError, zio.aws.elasticache.model.CacheCluster.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest,
        CacheCluster,
        DescribeCacheClustersPublisher
      ](
        "describeCacheClusters",
        api.describeCacheClustersPaginator,
        _.cacheClusters()
      )(request.buildAwsValue())
        .map(item => zio.aws.elasticache.model.CacheCluster.wrap(item))
        .provideEnvironment(r)
    def describeCacheClustersPaginated(
        request: DescribeCacheClustersRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeCacheClustersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest,
      DescribeCacheClustersResponse
    ]("describeCacheClusters", api.describeCacheClusters)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.DescribeCacheClustersResponse.wrap)
      .provideEnvironment(r)
    def createUserGroup(request: CreateUserGroupRequest): IO[
      AwsError,
      zio.aws.elasticache.model.CreateUserGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest,
      CreateUserGroupResponse
    ]("createUserGroup", api.createUserGroup)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.CreateUserGroupResponse.wrap)
      .provideEnvironment(r)
    def describeUserGroups(
        request: DescribeUserGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.elasticache.model.UserGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest,
        UserGroup,
        DescribeUserGroupsPublisher
      ]("describeUserGroups", api.describeUserGroupsPaginator, _.userGroups())(
        request.buildAwsValue()
      ).map(item => zio.aws.elasticache.model.UserGroup.wrap(item))
        .provideEnvironment(r)
    def describeUserGroupsPaginated(request: DescribeUserGroupsRequest): IO[
      AwsError,
      zio.aws.elasticache.model.DescribeUserGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest,
      DescribeUserGroupsResponse
    ]("describeUserGroups", api.describeUserGroups)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.DescribeUserGroupsResponse.wrap)
      .provideEnvironment(r)
    def modifyCacheParameterGroup(
        request: ModifyCacheParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest,
      ModifyCacheParameterGroupResponse
    ]("modifyCacheParameterGroup", api.modifyCacheParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def modifyCacheCluster(request: ModifyCacheClusterRequest): IO[
      AwsError,
      zio.aws.elasticache.model.ModifyCacheClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest,
      ModifyCacheClusterResponse
    ]("modifyCacheCluster", api.modifyCacheCluster)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.ModifyCacheClusterResponse.wrap)
      .provideEnvironment(r)
    def testFailover(
        request: TestFailoverRequest
    ): IO[AwsError, zio.aws.elasticache.model.TestFailoverResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.TestFailoverRequest,
        TestFailoverResponse
      ]("testFailover", api.testFailover)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.TestFailoverResponse.wrap)
        .provideEnvironment(r)
    def modifyGlobalReplicationGroup(
        request: ModifyGlobalReplicationGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.ModifyGlobalReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest,
      ModifyGlobalReplicationGroupResponse
    ]("modifyGlobalReplicationGroup", api.modifyGlobalReplicationGroup)(
      request.buildAwsValue()
    ).map(zio.aws.elasticache.model.ModifyGlobalReplicationGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteCacheCluster(request: DeleteCacheClusterRequest): IO[
      AwsError,
      zio.aws.elasticache.model.DeleteCacheClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest,
      DeleteCacheClusterResponse
    ]("deleteCacheCluster", api.deleteCacheCluster)(request.buildAwsValue())
      .map(zio.aws.elasticache.model.DeleteCacheClusterResponse.wrap)
      .provideEnvironment(r)
    def modifyReplicationGroupShardConfiguration(
        request: ModifyReplicationGroupShardConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest,
      ModifyReplicationGroupShardConfigurationResponse
    ](
      "modifyReplicationGroupShardConfiguration",
      api.modifyReplicationGroupShardConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createSnapshot(
        request: CreateSnapshotRequest
    ): IO[AwsError, zio.aws.elasticache.model.CreateSnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest,
        CreateSnapshotResponse
      ]("createSnapshot", api.createSnapshot)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.CreateSnapshotResponse.wrap)
        .provideEnvironment(r)
    def describeEvents(
        request: DescribeEventsRequest
    ): ZStream[Any, AwsError, zio.aws.elasticache.model.Event.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest,
        Event,
        DescribeEventsPublisher
      ]("describeEvents", api.describeEventsPaginator, _.events())(
        request.buildAwsValue()
      ).map(item => zio.aws.elasticache.model.Event.wrap(item))
        .provideEnvironment(r)
    def describeEventsPaginated(
        request: DescribeEventsRequest
    ): IO[AwsError, zio.aws.elasticache.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest,
        DescribeEventsResponse
      ]("describeEvents", api.describeEvents)(request.buildAwsValue())
        .map(zio.aws.elasticache.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
    def decreaseNodeGroupsInGlobalReplicationGroup(
        request: DecreaseNodeGroupsInGlobalReplicationGroupRequest
    ): IO[
      AwsError,
      zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest,
      DecreaseNodeGroupsInGlobalReplicationGroupResponse
    ](
      "decreaseNodeGroupsInGlobalReplicationGroup",
      api.decreaseNodeGroupsInGlobalReplicationGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.wrap
      )
      .provideEnvironment(r)
  }
  def describeEngineDefaultParameters(
      request: DescribeEngineDefaultParametersRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngineDefaultParameters(request))
  def describeCacheSecurityGroups(
      request: DescribeCacheSecurityGroupsRequest
  ): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCacheSecurityGroups(request))
  def describeCacheSecurityGroupsPaginated(
      request: DescribeCacheSecurityGroupsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCacheSecurityGroupsPaginated(request))
  def resetCacheParameterGroup(request: ResetCacheParameterGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ResetCacheParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetCacheParameterGroup(request))
  def describeCacheParameters(request: DescribeCacheParametersRequest): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.Parameter.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCacheParameters(request))
  def describeCacheParametersPaginated(
      request: DescribeCacheParametersRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeCacheParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCacheParametersPaginated(request))
  def addTagsToResource(request: AddTagsToResourceRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.AddTagsToResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTagsToResource(request))
  def createCacheParameterGroup(request: CreateCacheParameterGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateCacheParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCacheParameterGroup(request))
  def createGlobalReplicationGroup(
      request: CreateGlobalReplicationGroupRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGlobalReplicationGroup(request))
  def deleteCacheParameterGroup(
      request: DeleteCacheParameterGroupRequest
  ): ZIO[zio.aws.elasticache.ElastiCache, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCacheParameterGroup(request))
  def completeMigration(request: CompleteMigrationRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CompleteMigrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.completeMigration(request))
  def deleteGlobalReplicationGroup(
      request: DeleteGlobalReplicationGroupRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGlobalReplicationGroup(request))
  def describeCacheParameterGroups(
      request: DescribeCacheParameterGroupsRequest
  ): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CacheParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCacheParameterGroups(request))
  def describeCacheParameterGroupsPaginated(
      request: DescribeCacheParameterGroupsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCacheParameterGroupsPaginated(request))
  def increaseReplicaCount(request: IncreaseReplicaCountRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.IncreaseReplicaCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.increaseReplicaCount(request))
  def modifyUser(request: ModifyUserRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ModifyUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyUser(request))
  def describeCacheEngineVersions(
      request: DescribeCacheEngineVersionsRequest
  ): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CacheEngineVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCacheEngineVersions(request))
  def describeCacheEngineVersionsPaginated(
      request: DescribeCacheEngineVersionsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCacheEngineVersionsPaginated(request))
  def listAllowedNodeTypeModifications(
      request: ListAllowedNodeTypeModificationsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAllowedNodeTypeModifications(request))
  def deleteReplicationGroup(request: DeleteReplicationGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DeleteReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationGroup(request))
  def createReplicationGroup(request: CreateReplicationGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationGroup(request))
  def describeCacheSubnetGroups(
      request: DescribeCacheSubnetGroupsRequest
  ): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCacheSubnetGroups(request))
  def describeCacheSubnetGroupsPaginated(
      request: DescribeCacheSubnetGroupsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCacheSubnetGroupsPaginated(request))
  def modifyCacheSubnetGroup(request: ModifyCacheSubnetGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCacheSubnetGroup(request))
  def modifyReplicationGroup(request: ModifyReplicationGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ModifyReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationGroup(request))
  def copySnapshot(request: CopySnapshotRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CopySnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copySnapshot(request))
  def purchaseReservedCacheNodesOffering(
      request: PurchaseReservedCacheNodesOfferingRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseReservedCacheNodesOffering(request))
  def increaseNodeGroupsInGlobalReplicationGroup(
      request: IncreaseNodeGroupsInGlobalReplicationGroupRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.increaseNodeGroupsInGlobalReplicationGroup(request))
  def removeTagsFromResource(request: RemoveTagsFromResourceRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.RemoveTagsFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def decreaseReplicaCount(request: DecreaseReplicaCountRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DecreaseReplicaCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.decreaseReplicaCount(request))
  def rebalanceSlotsInGlobalReplicationGroup(
      request: RebalanceSlotsInGlobalReplicationGroupRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebalanceSlotsInGlobalReplicationGroup(request))
  def describeUpdateActions(request: DescribeUpdateActionsRequest): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.UpdateAction.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUpdateActions(request))
  def describeUpdateActionsPaginated(
      request: DescribeUpdateActionsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUpdateActionsPaginated(request))
  def createUser(request: CreateUserRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def authorizeCacheSecurityGroupIngress(
      request: AuthorizeCacheSecurityGroupIngressRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeCacheSecurityGroupIngress(request))
  def deleteCacheSubnetGroup(
      request: DeleteCacheSubnetGroupRequest
  ): ZIO[zio.aws.elasticache.ElastiCache, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCacheSubnetGroup(request))
  def deleteSnapshot(request: DeleteSnapshotRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DeleteSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSnapshot(request))
  def describeReplicationGroups(
      request: DescribeReplicationGroupsRequest
  ): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ReplicationGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReplicationGroups(request))
  def describeReplicationGroupsPaginated(
      request: DescribeReplicationGroupsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationGroupsPaginated(request))
  def describeReservedCacheNodes(
      request: DescribeReservedCacheNodesRequest
  ): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ReservedCacheNode.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedCacheNodes(request))
  def describeReservedCacheNodesPaginated(
      request: DescribeReservedCacheNodesRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedCacheNodesPaginated(request))
  def describeServiceUpdates(request: DescribeServiceUpdatesRequest): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ServiceUpdate.ReadOnly
  ] = ZStream.serviceWithStream(_.describeServiceUpdates(request))
  def describeServiceUpdatesPaginated(
      request: DescribeServiceUpdatesRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeServiceUpdatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServiceUpdatesPaginated(request))
  def modifyUserGroup(request: ModifyUserGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ModifyUserGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyUserGroup(request))
  def describeUsers(request: DescribeUsersRequest): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.User.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUsers(request))
  def describeUsersPaginated(request: DescribeUsersRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUsersPaginated(request))
  def createCacheSecurityGroup(request: CreateCacheSecurityGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCacheSecurityGroup(request))
  def batchApplyUpdateAction(request: BatchApplyUpdateActionRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.BatchApplyUpdateActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchApplyUpdateAction(request))
  def createCacheCluster(request: CreateCacheClusterRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateCacheClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCacheCluster(request))
  def deleteCacheSecurityGroup(
      request: DeleteCacheSecurityGroupRequest
  ): ZIO[zio.aws.elasticache.ElastiCache, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCacheSecurityGroup(request))
  def describeGlobalReplicationGroups(
      request: DescribeGlobalReplicationGroupsRequest
  ): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGlobalReplicationGroups(request))
  def describeGlobalReplicationGroupsPaginated(
      request: DescribeGlobalReplicationGroupsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGlobalReplicationGroupsPaginated(request))
  def disassociateGlobalReplicationGroup(
      request: DisassociateGlobalReplicationGroupRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DisassociateGlobalReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateGlobalReplicationGroup(request))
  def describeReservedCacheNodesOfferings(
      request: DescribeReservedCacheNodesOfferingsRequest
  ): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedCacheNodesOfferings(request))
  def describeReservedCacheNodesOfferingsPaginated(
      request: DescribeReservedCacheNodesOfferingsRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeReservedCacheNodesOfferingsPaginated(request))
  def describeSnapshots(request: DescribeSnapshotsRequest): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.Snapshot.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSnapshots(request))
  def describeSnapshotsPaginated(request: DescribeSnapshotsRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSnapshotsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def rebootCacheCluster(request: RebootCacheClusterRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.RebootCacheClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootCacheCluster(request))
  def deleteUser(request: DeleteUserRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DeleteUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUser(request))
  def deleteUserGroup(request: DeleteUserGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DeleteUserGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUserGroup(request))
  def revokeCacheSecurityGroupIngress(
      request: RevokeCacheSecurityGroupIngressRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeCacheSecurityGroupIngress(request))
  def startMigration(request: StartMigrationRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.StartMigrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMigration(request))
  def createCacheSubnetGroup(request: CreateCacheSubnetGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCacheSubnetGroup(request))
  def failoverGlobalReplicationGroup(
      request: FailoverGlobalReplicationGroupRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.failoverGlobalReplicationGroup(request))
  def batchStopUpdateAction(
      request: BatchStopUpdateActionRequest
  ): ZIO[zio.aws.elasticache.ElastiCache, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.batchStopUpdateAction(request))
  def describeCacheClusters(request: DescribeCacheClustersRequest): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CacheCluster.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCacheClusters(request))
  def describeCacheClustersPaginated(
      request: DescribeCacheClustersRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeCacheClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCacheClustersPaginated(request))
  def createUserGroup(request: CreateUserGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateUserGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserGroup(request))
  def describeUserGroups(request: DescribeUserGroupsRequest): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.UserGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUserGroups(request))
  def describeUserGroupsPaginated(request: DescribeUserGroupsRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeUserGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserGroupsPaginated(request))
  def modifyCacheParameterGroup(request: ModifyCacheParameterGroupRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCacheParameterGroup(request))
  def modifyCacheCluster(request: ModifyCacheClusterRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ModifyCacheClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCacheCluster(request))
  def testFailover(request: TestFailoverRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.TestFailoverResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testFailover(request))
  def modifyGlobalReplicationGroup(
      request: ModifyGlobalReplicationGroupRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ModifyGlobalReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyGlobalReplicationGroup(request))
  def deleteCacheCluster(request: DeleteCacheClusterRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DeleteCacheClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCacheCluster(request))
  def modifyReplicationGroupShardConfiguration(
      request: ModifyReplicationGroupShardConfigurationRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationGroupShardConfiguration(request))
  def createSnapshot(request: CreateSnapshotRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.CreateSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshot(request))
  def describeEvents(request: DescribeEventsRequest): ZStream[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.Event.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(request: DescribeEventsRequest): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
  def decreaseNodeGroupsInGlobalReplicationGroup(
      request: DecreaseNodeGroupsInGlobalReplicationGroupRequest
  ): ZIO[
    zio.aws.elasticache.ElastiCache,
    AwsError,
    zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.decreaseNodeGroupsInGlobalReplicationGroup(request))
}
