package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait AZMode {
  def unwrap: software.amazon.awssdk.services.elasticache.model.AZMode
}
object AZMode {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.AZMode
  ): zio.aws.elasticache.model.AZMode = value match {
    case software.amazon.awssdk.services.elasticache.model.AZMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.AZMode.SINGLE_AZ =>
      val r = `single-az`
      r
    case software.amazon.awssdk.services.elasticache.model.AZMode.CROSS_AZ =>
      val r = `cross-az`
      r
  }
  case object unknownToSdkVersion extends zio.aws.elasticache.model.AZMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AZMode =
      software.amazon.awssdk.services.elasticache.model.AZMode.UNKNOWN_TO_SDK_VERSION
  }
  case object `single-az` extends zio.aws.elasticache.model.AZMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AZMode =
      software.amazon.awssdk.services.elasticache.model.AZMode.SINGLE_AZ
  }
  case object `cross-az` extends zio.aws.elasticache.model.AZMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AZMode =
      software.amazon.awssdk.services.elasticache.model.AZMode.CROSS_AZ
  }
}
