package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait AutomaticFailoverStatus {
  def unwrap: software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus
}
object AutomaticFailoverStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus
  ): zio.aws.elasticache.model.AutomaticFailoverStatus = value match {
    case software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.ENABLING =>
      val r = enabling
      r
    case software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.DISABLING =>
      val r = disabling
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.AutomaticFailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus =
      software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled
      extends zio.aws.elasticache.model.AutomaticFailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus =
      software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.ENABLED
  }
  case object disabled
      extends zio.aws.elasticache.model.AutomaticFailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus =
      software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.DISABLED
  }
  case object enabling
      extends zio.aws.elasticache.model.AutomaticFailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus =
      software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.ENABLING
  }
  case object disabling
      extends zio.aws.elasticache.model.AutomaticFailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus =
      software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus.DISABLING
  }
}
