package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AvailabilityZone(name: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.AvailabilityZone
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.AvailabilityZone.ReadOnly =
    zio.aws.elasticache.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.AvailabilityZone =
      zio.aws.elasticache.model.AvailabilityZone(name.map(value => value))
    def name: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.AvailabilityZone
  ) extends zio.aws.elasticache.model.AvailabilityZone.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.AvailabilityZone
  ): zio.aws.elasticache.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
