package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchApplyUpdateActionRequest(
    replicationGroupIds: Optional[Iterable[String]] = Optional.Absent,
    cacheClusterIds: Optional[Iterable[String]] = Optional.Absent,
    serviceUpdateName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest = {
    import BatchApplyUpdateActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest
      .builder()
      .optionallyWith(
        replicationGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationGroupIds)
      .optionallyWith(
        cacheClusterIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheClusterIds)
      .serviceUpdateName(serviceUpdateName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.BatchApplyUpdateActionRequest.ReadOnly =
    zio.aws.elasticache.model.BatchApplyUpdateActionRequest
      .wrap(buildAwsValue())
}
object BatchApplyUpdateActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.BatchApplyUpdateActionRequest =
      zio.aws.elasticache.model.BatchApplyUpdateActionRequest(
        replicationGroupIds.map(value => value),
        cacheClusterIds.map(value => value),
        serviceUpdateName
      )
    def replicationGroupIds: Optional[List[String]]
    def cacheClusterIds: Optional[List[String]]
    def serviceUpdateName: String
    def getReplicationGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicationGroupIds", replicationGroupIds)
    def getCacheClusterIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheClusterIds", cacheClusterIds)
    def getServiceUpdateName: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceUpdateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest
  ) extends zio.aws.elasticache.model.BatchApplyUpdateActionRequest.ReadOnly {
    override val replicationGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val cacheClusterIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceUpdateName: String = impl.serviceUpdateName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest
  ): zio.aws.elasticache.model.BatchApplyUpdateActionRequest.ReadOnly =
    new Wrapper(impl)
}
