package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CacheSecurityGroup(
    ownerId: Optional[String] = Optional.Absent,
    cacheSecurityGroupName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    ec2SecurityGroups: Optional[
      Iterable[zio.aws.elasticache.model.EC2SecurityGroup]
    ] = Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup = {
    import CacheSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        cacheSecurityGroupName.map(value => value: java.lang.String)
      )(_.cacheSecurityGroupName)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2SecurityGroups)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly =
    zio.aws.elasticache.model.CacheSecurityGroup.wrap(buildAwsValue())
}
object CacheSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheSecurityGroup =
      zio.aws.elasticache.model.CacheSecurityGroup(
        ownerId.map(value => value),
        cacheSecurityGroupName.map(value => value),
        description.map(value => value),
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arn.map(value => value)
      )
    def ownerId: Optional[String]
    def cacheSecurityGroupName: Optional[String]
    def description: Optional[String]
    def ec2SecurityGroups
        : Optional[List[zio.aws.elasticache.model.EC2SecurityGroup.ReadOnly]]
    def arn: Optional[String]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCacheSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheSecurityGroupName", cacheSecurityGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.EC2SecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2SecurityGroups", ec2SecurityGroups)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup
  ) extends zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly {
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val cacheSecurityGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSecurityGroupName())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val ec2SecurityGroups
        : Optional[List[zio.aws.elasticache.model.EC2SecurityGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.EC2SecurityGroup.wrap(item)
          }.toList
        )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup
  ): zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly = new Wrapper(impl)
}
