package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSnapshotRequest(
    replicationGroupId: Optional[String] = Optional.Absent,
    cacheClusterId: Optional[String] = Optional.Absent,
    snapshotName: String,
    kmsKeyId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticache.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest = {
    import CreateSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .snapshotName(snapshotName: java.lang.String)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CreateSnapshotRequest.ReadOnly =
    zio.aws.elasticache.model.CreateSnapshotRequest.wrap(buildAwsValue())
}
object CreateSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateSnapshotRequest =
      zio.aws.elasticache.model.CreateSnapshotRequest(
        replicationGroupId.map(value => value),
        cacheClusterId.map(value => value),
        snapshotName,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationGroupId: Optional[String]
    def cacheClusterId: Optional[String]
    def snapshotName: String
    def kmsKeyId: Optional[String]
    def tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getSnapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotName)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest
  ) extends zio.aws.elasticache.model.CreateSnapshotRequest.ReadOnly {
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val snapshotName: String = impl.snapshotName(): String
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest
  ): zio.aws.elasticache.model.CreateSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
