package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{UserId, EngineType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUserGroupRequest(
    userGroupId: String,
    engine: EngineType,
    userIds: Optional[Iterable[UserId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticache.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest = {
    import CreateUserGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest
      .builder()
      .userGroupId(userGroupId: java.lang.String)
      .engine(EngineType.unwrap(engine): java.lang.String)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CreateUserGroupRequest.ReadOnly =
    zio.aws.elasticache.model.CreateUserGroupRequest.wrap(buildAwsValue())
}
object CreateUserGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateUserGroupRequest =
      zio.aws.elasticache.model.CreateUserGroupRequest(
        userGroupId,
        engine,
        userIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userGroupId: String
    def engine: EngineType
    def userIds: Optional[List[UserId]]
    def tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getUserGroupId: ZIO[Any, Nothing, String] = ZIO.succeed(userGroupId)
    def getEngine: ZIO[Any, Nothing, EngineType] = ZIO.succeed(engine)
    def getUserIds: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest
  ) extends zio.aws.elasticache.model.CreateUserGroupRequest.ReadOnly {
    override val userGroupId: String = impl.userGroupId(): String
    override val engine: EngineType =
      zio.aws.elasticache.model.primitives.EngineType(impl.engine())
    override val userIds: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserId(item)
        }.toList
      )
    override val tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest
  ): zio.aws.elasticache.model.CreateUserGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
