package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{
  EngineType,
  UserId,
  BooleanOptional,
  AccessString,
  UserName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUserRequest(
    userId: UserId,
    userName: UserName,
    engine: EngineType,
    passwords: Optional[Iterable[String]] = Optional.Absent,
    accessString: AccessString,
    noPasswordRequired: Optional[BooleanOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticache.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .userName(UserName.unwrap(userName): java.lang.String)
      .engine(EngineType.unwrap(engine): java.lang.String)
      .optionallyWith(
        passwords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.passwords)
      .accessString(AccessString.unwrap(accessString): java.lang.String)
      .optionallyWith(
        noPasswordRequired.map(value => value: java.lang.Boolean)
      )(_.noPasswordRequired)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CreateUserRequest.ReadOnly =
    zio.aws.elasticache.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateUserRequest =
      zio.aws.elasticache.model.CreateUserRequest(
        userId,
        userName,
        engine,
        passwords.map(value => value),
        accessString,
        noPasswordRequired.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userId: UserId
    def userName: UserName
    def engine: EngineType
    def passwords: Optional[List[String]]
    def accessString: AccessString
    def noPasswordRequired: Optional[BooleanOptional]
    def tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
    def getEngine: ZIO[Any, Nothing, EngineType] = ZIO.succeed(engine)
    def getPasswords: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("passwords", passwords)
    def getAccessString: ZIO[Any, Nothing, AccessString] =
      ZIO.succeed(accessString)
    def getNoPasswordRequired: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("noPasswordRequired", noPasswordRequired)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateUserRequest
  ) extends zio.aws.elasticache.model.CreateUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.elasticache.model.primitives.UserId(impl.userId())
    override val userName: UserName =
      zio.aws.elasticache.model.primitives.UserName(impl.userName())
    override val engine: EngineType =
      zio.aws.elasticache.model.primitives.EngineType(impl.engine())
    override val passwords: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.passwords())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val accessString: AccessString =
      zio.aws.elasticache.model.primitives.AccessString(impl.accessString())
    override val noPasswordRequired: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noPasswordRequired())
        .map(value => value: BooleanOptional)
    override val tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateUserRequest
  ): zio.aws.elasticache.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
