package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeCacheSubnetGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    cacheSubnetGroups: Optional[
      Iterable[zio.aws.elasticache.model.CacheSubnetGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse = {
    import DescribeCacheSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        cacheSubnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheSubnetGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeCacheSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse =
      zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse(
        marker.map(value => value),
        cacheSubnetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def cacheSubnetGroups
        : Optional[List[zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCacheSubnetGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheSubnetGroups", cacheSubnetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse
  ) extends zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val cacheSubnetGroups
        : Optional[List[zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSubnetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.CacheSubnetGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse
  ): zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
