package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeGlobalReplicationGroupsRequest(
    globalReplicationGroupId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    showMemberInfo: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest = {
    import DescribeGlobalReplicationGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest
      .builder()
      .optionallyWith(
        globalReplicationGroupId.map(value => value: java.lang.String)
      )(_.globalReplicationGroupId)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(showMemberInfo.map(value => value: java.lang.Boolean))(
        _.showMemberInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeGlobalReplicationGroupsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeGlobalReplicationGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeGlobalReplicationGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeGlobalReplicationGroupsRequest =
      zio.aws.elasticache.model.DescribeGlobalReplicationGroupsRequest(
        globalReplicationGroupId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        showMemberInfo.map(value => value)
      )
    def globalReplicationGroupId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def showMemberInfo: Optional[BooleanOptional]
    def getGlobalReplicationGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalReplicationGroupId", globalReplicationGroupId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getShowMemberInfo: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showMemberInfo", showMemberInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest
  ) extends zio.aws.elasticache.model.DescribeGlobalReplicationGroupsRequest.ReadOnly {
    override val globalReplicationGroupId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroupId())
        .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val showMemberInfo: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.showMemberInfo())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest
  ): zio.aws.elasticache.model.DescribeGlobalReplicationGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
