package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeGlobalReplicationGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    globalReplicationGroups: Optional[
      Iterable[zio.aws.elasticache.model.GlobalReplicationGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse = {
    import DescribeGlobalReplicationGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        globalReplicationGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalReplicationGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeGlobalReplicationGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse =
      zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse(
        marker.map(value => value),
        globalReplicationGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def globalReplicationGroups: Optional[
      List[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getGlobalReplicationGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalReplicationGroups",
      globalReplicationGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse
  ) extends zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val globalReplicationGroups: Optional[
      List[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.globalReplicationGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.GlobalReplicationGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse
  ): zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
