package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeReplicationGroupsRequest(
    replicationGroupId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest = {
    import DescribeReplicationGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReplicationGroupsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeReplicationGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeReplicationGroupsRequest =
      zio.aws.elasticache.model.DescribeReplicationGroupsRequest(
        replicationGroupId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def replicationGroupId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest
  ) extends zio.aws.elasticache.model.DescribeReplicationGroupsRequest.ReadOnly {
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest
  ): zio.aws.elasticache.model.DescribeReplicationGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
