package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeReservedCacheNodesOfferingsResponse(
    marker: Optional[String] = Optional.Absent,
    reservedCacheNodesOfferings: Optional[
      Iterable[zio.aws.elasticache.model.ReservedCacheNodesOffering]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse = {
    import DescribeReservedCacheNodesOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedCacheNodesOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedCacheNodesOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedCacheNodesOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse =
      zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse(
        marker.map(value => value),
        reservedCacheNodesOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def reservedCacheNodesOfferings: Optional[
      List[zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedCacheNodesOfferings: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedCacheNodesOfferings",
      reservedCacheNodesOfferings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
  ) extends zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val reservedCacheNodesOfferings: Optional[
      List[zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedCacheNodesOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ReservedCacheNodesOffering.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
  ): zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
