package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeUserGroupsRequest(
    userGroupId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest = {
    import DescribeUserGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest
      .builder()
      .optionallyWith(userGroupId.map(value => value: java.lang.String))(
        _.userGroupId
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DescribeUserGroupsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeUserGroupsRequest.wrap(buildAwsValue())
}
object DescribeUserGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUserGroupsRequest =
      zio.aws.elasticache.model.DescribeUserGroupsRequest(
        userGroupId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def userGroupId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getUserGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userGroupId", userGroupId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest
  ) extends zio.aws.elasticache.model.DescribeUserGroupsRequest.ReadOnly {
    override val userGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userGroupId())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest
  ): zio.aws.elasticache.model.DescribeUserGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
