package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait LogFormat {
  def unwrap: software.amazon.awssdk.services.elasticache.model.LogFormat
}
object LogFormat {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.LogFormat
  ): zio.aws.elasticache.model.LogFormat = value match {
    case software.amazon.awssdk.services.elasticache.model.LogFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.LogFormat.TEXT =>
      val r = text
      r
    case software.amazon.awssdk.services.elasticache.model.LogFormat.JSON =>
      val r = json
      r
  }
  case object unknownToSdkVersion extends zio.aws.elasticache.model.LogFormat {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.LogFormat =
      software.amazon.awssdk.services.elasticache.model.LogFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object text extends zio.aws.elasticache.model.LogFormat {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.LogFormat =
      software.amazon.awssdk.services.elasticache.model.LogFormat.TEXT
  }
  case object json extends zio.aws.elasticache.model.LogFormat {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.LogFormat =
      software.amazon.awssdk.services.elasticache.model.LogFormat.JSON
  }
}
