package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait MultiAZStatus {
  def unwrap: software.amazon.awssdk.services.elasticache.model.MultiAZStatus
}
object MultiAZStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.MultiAZStatus
  ): zio.aws.elasticache.model.MultiAZStatus = value match {
    case software.amazon.awssdk.services.elasticache.model.MultiAZStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.MultiAZStatus.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.elasticache.model.MultiAZStatus.DISABLED =>
      val r = disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.MultiAZStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.MultiAZStatus =
      software.amazon.awssdk.services.elasticache.model.MultiAZStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled extends zio.aws.elasticache.model.MultiAZStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.MultiAZStatus =
      software.amazon.awssdk.services.elasticache.model.MultiAZStatus.ENABLED
  }
  case object disabled extends zio.aws.elasticache.model.MultiAZStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.MultiAZStatus =
      software.amazon.awssdk.services.elasticache.model.MultiAZStatus.DISABLED
  }
}
