package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait OutpostMode {
  def unwrap: software.amazon.awssdk.services.elasticache.model.OutpostMode
}
object OutpostMode {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.OutpostMode
  ): zio.aws.elasticache.model.OutpostMode = value match {
    case software.amazon.awssdk.services.elasticache.model.OutpostMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.OutpostMode.SINGLE_OUTPOST =>
      val r = `single-outpost`
      r
    case software.amazon.awssdk.services.elasticache.model.OutpostMode.CROSS_OUTPOST =>
      val r = `cross-outpost`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.OutpostMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.OutpostMode =
      software.amazon.awssdk.services.elasticache.model.OutpostMode.UNKNOWN_TO_SDK_VERSION
  }
  case object `single-outpost` extends zio.aws.elasticache.model.OutpostMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.OutpostMode =
      software.amazon.awssdk.services.elasticache.model.OutpostMode.SINGLE_OUTPOST
  }
  case object `cross-outpost` extends zio.aws.elasticache.model.OutpostMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.OutpostMode =
      software.amazon.awssdk.services.elasticache.model.OutpostMode.CROSS_OUTPOST
  }
}
