package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProcessedUpdateAction(
    replicationGroupId: Optional[String] = Optional.Absent,
    cacheClusterId: Optional[String] = Optional.Absent,
    serviceUpdateName: Optional[String] = Optional.Absent,
    updateActionStatus: Optional[zio.aws.elasticache.model.UpdateActionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ProcessedUpdateAction = {
    import ProcessedUpdateAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ProcessedUpdateAction
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(updateActionStatus.map(value => value.unwrap))(
        _.updateActionStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly =
    zio.aws.elasticache.model.ProcessedUpdateAction.wrap(buildAwsValue())
}
object ProcessedUpdateAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ProcessedUpdateAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ProcessedUpdateAction =
      zio.aws.elasticache.model.ProcessedUpdateAction(
        replicationGroupId.map(value => value),
        cacheClusterId.map(value => value),
        serviceUpdateName.map(value => value),
        updateActionStatus.map(value => value)
      )
    def replicationGroupId: Optional[String]
    def cacheClusterId: Optional[String]
    def serviceUpdateName: Optional[String]
    def updateActionStatus
        : Optional[zio.aws.elasticache.model.UpdateActionStatus]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getUpdateActionStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.UpdateActionStatus] =
      AwsError.unwrapOptionField("updateActionStatus", updateActionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ProcessedUpdateAction
  ) extends zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly {
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val serviceUpdateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateName())
      .map(value => value: String)
    override val updateActionStatus
        : Optional[zio.aws.elasticache.model.UpdateActionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateActionStatus())
        .map(value => zio.aws.elasticache.model.UpdateActionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ProcessedUpdateAction
  ): zio.aws.elasticache.model.ProcessedUpdateAction.ReadOnly = new Wrapper(
    impl
  )
}
