package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceUpdateStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus
}
object ServiceUpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus
  ): zio.aws.elasticache.model.ServiceUpdateStatus = value match {
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus.EXPIRED =>
      val r = expired
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object available extends zio.aws.elasticache.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus.AVAILABLE
  }
  case object cancelled extends zio.aws.elasticache.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus.CANCELLED
  }
  case object expired extends zio.aws.elasticache.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus.EXPIRED
  }
}
