package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceUpdateType {
  def unwrap
      : software.amazon.awssdk.services.elasticache.model.ServiceUpdateType
}
object ServiceUpdateType {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.ServiceUpdateType
  ): zio.aws.elasticache.model.ServiceUpdateType = value match {
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.ServiceUpdateType.SECURITY_UPDATE =>
      val r = `security-update`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.ServiceUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateType =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateType.UNKNOWN_TO_SDK_VERSION
  }
  case object `security-update`
      extends zio.aws.elasticache.model.ServiceUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ServiceUpdateType =
      software.amazon.awssdk.services.elasticache.model.ServiceUpdateType.SECURITY_UPDATE
  }
}
