package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.elasticache.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.SourceType
  ): zio.aws.elasticache.model.SourceType = value match {
    case software.amazon.awssdk.services.elasticache.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.SourceType.CACHE_CLUSTER =>
      val r = `cache-cluster`
      r
    case software.amazon.awssdk.services.elasticache.model.SourceType.CACHE_PARAMETER_GROUP =>
      val r = `cache-parameter-group`
      r
    case software.amazon.awssdk.services.elasticache.model.SourceType.CACHE_SECURITY_GROUP =>
      val r = `cache-security-group`
      r
    case software.amazon.awssdk.services.elasticache.model.SourceType.CACHE_SUBNET_GROUP =>
      val r = `cache-subnet-group`
      r
    case software.amazon.awssdk.services.elasticache.model.SourceType.REPLICATION_GROUP =>
      val r = `replication-group`
      r
    case software.amazon.awssdk.services.elasticache.model.SourceType.USER =>
      val r = user
      r
    case software.amazon.awssdk.services.elasticache.model.SourceType.USER_GROUP =>
      val r = `user-group`
      r
  }
  case object unknownToSdkVersion extends zio.aws.elasticache.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SourceType =
      software.amazon.awssdk.services.elasticache.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `cache-cluster` extends zio.aws.elasticache.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SourceType =
      software.amazon.awssdk.services.elasticache.model.SourceType.CACHE_CLUSTER
  }
  case object `cache-parameter-group`
      extends zio.aws.elasticache.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SourceType =
      software.amazon.awssdk.services.elasticache.model.SourceType.CACHE_PARAMETER_GROUP
  }
  case object `cache-security-group`
      extends zio.aws.elasticache.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SourceType =
      software.amazon.awssdk.services.elasticache.model.SourceType.CACHE_SECURITY_GROUP
  }
  case object `cache-subnet-group`
      extends zio.aws.elasticache.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SourceType =
      software.amazon.awssdk.services.elasticache.model.SourceType.CACHE_SUBNET_GROUP
  }
  case object `replication-group` extends zio.aws.elasticache.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SourceType =
      software.amazon.awssdk.services.elasticache.model.SourceType.REPLICATION_GROUP
  }
  case object user extends zio.aws.elasticache.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SourceType =
      software.amazon.awssdk.services.elasticache.model.SourceType.USER
  }
  case object `user-group` extends zio.aws.elasticache.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.SourceType =
      software.amazon.awssdk.services.elasticache.model.SourceType.USER_GROUP
  }
}
