package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.PolicyDocument
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AccessPoliciesStatus(
    options: PolicyDocument,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus = {
    import AccessPoliciesStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus
      .builder()
      .options(PolicyDocument.unwrap(options): java.lang.String)
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly =
    zio.aws.elasticsearch.model.AccessPoliciesStatus.wrap(buildAwsValue())
}
object AccessPoliciesStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AccessPoliciesStatus =
      zio.aws.elasticsearch.model
        .AccessPoliciesStatus(options, status.asEditable)
    def options: PolicyDocument
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[Any, Nothing, PolicyDocument] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus
  ) extends zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly {
    override val options: PolicyDocument =
      zio.aws.elasticsearch.model.primitives.PolicyDocument(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus
  ): zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly = new Wrapper(
    impl
  )
}
