package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AdvancedSecurityOptionsInput(
    enabled: Optional[Boolean] = Optional.Absent,
    internalUserDatabaseEnabled: Optional[Boolean] = Optional.Absent,
    masterUserOptions: Optional[zio.aws.elasticsearch.model.MasterUserOptions] =
      Optional.Absent,
    samlOptions: Optional[zio.aws.elasticsearch.model.SAMLOptionsInput] =
      Optional.Absent,
    anonymousAuthEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput = {
    import AdvancedSecurityOptionsInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        internalUserDatabaseEnabled.map(value => value: java.lang.Boolean)
      )(_.internalUserDatabaseEnabled)
      .optionallyWith(masterUserOptions.map(value => value.buildAwsValue()))(
        _.masterUserOptions
      )
      .optionallyWith(samlOptions.map(value => value.buildAwsValue()))(
        _.samlOptions
      )
      .optionallyWith(
        anonymousAuthEnabled.map(value => value: java.lang.Boolean)
      )(_.anonymousAuthEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly =
    zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput
      .wrap(buildAwsValue())
}
object AdvancedSecurityOptionsInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput =
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput(
        enabled.map(value => value),
        internalUserDatabaseEnabled.map(value => value),
        masterUserOptions.map(value => value.asEditable),
        samlOptions.map(value => value.asEditable),
        anonymousAuthEnabled.map(value => value)
      )
    def enabled: Optional[Boolean]
    def internalUserDatabaseEnabled: Optional[Boolean]
    def masterUserOptions
        : Optional[zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly]
    def samlOptions
        : Optional[zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly]
    def anonymousAuthEnabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getInternalUserDatabaseEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "internalUserDatabaseEnabled",
        internalUserDatabaseEnabled
      )
    def getMasterUserOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly
    ] = AwsError.unwrapOptionField("masterUserOptions", masterUserOptions)
    def getSamlOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly
    ] = AwsError.unwrapOptionField("samlOptions", samlOptions)
    def getAnonymousAuthEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("anonymousAuthEnabled", anonymousAuthEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput
  ) extends zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val internalUserDatabaseEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internalUserDatabaseEnabled())
        .map(value => value: Boolean)
    override val masterUserOptions
        : Optional[zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserOptions())
        .map(value => zio.aws.elasticsearch.model.MasterUserOptions.wrap(value))
    override val samlOptions
        : Optional[zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samlOptions())
        .map(value => zio.aws.elasticsearch.model.SAMLOptionsInput.wrap(value))
    override val anonymousAuthEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.anonymousAuthEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput
  ): zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly =
    new Wrapper(impl)
}
