package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{AWSAccount, DomainName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AuthorizeVpcEndpointAccessRequest(
    domainName: DomainName,
    account: AWSAccount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessRequest = {
    import AuthorizeVpcEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .account(AWSAccount.unwrap(account): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.AuthorizeVpcEndpointAccessRequest.ReadOnly =
    zio.aws.elasticsearch.model.AuthorizeVpcEndpointAccessRequest
      .wrap(buildAwsValue())
}
object AuthorizeVpcEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.AuthorizeVpcEndpointAccessRequest =
      zio.aws.elasticsearch.model
        .AuthorizeVpcEndpointAccessRequest(domainName, account)
    def domainName: DomainName
    def account: AWSAccount
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getAccount: ZIO[Any, Nothing, AWSAccount] = ZIO.succeed(account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessRequest
  ) extends zio.aws.elasticsearch.model.AuthorizeVpcEndpointAccessRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val account: AWSAccount =
      zio.aws.elasticsearch.model.primitives.AWSAccount(impl.account())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessRequest
  ): zio.aws.elasticsearch.model.AuthorizeVpcEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
