package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait AutoTuneDesiredState {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState
}
object AutoTuneDesiredState {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState
  ): zio.aws.elasticsearch.model.AutoTuneDesiredState = value match {
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.AutoTuneDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.elasticsearch.model.AutoTuneDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState.ENABLED
  }
  case object DISABLED
      extends zio.aws.elasticsearch.model.AutoTuneDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState.DISABLED
  }
}
